/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.guide.tags.block;

import guideme.compiler.IdUtils;
import guideme.compiler.IndexingContext;
import guideme.compiler.IndexingSink;
import guideme.compiler.PageCompiler;
import guideme.compiler.tags.FlowTagCompiler;
import guideme.compiler.tags.MdxAttrs;
import guideme.document.LytErrorSink;
import guideme.document.block.LytBlock;
import guideme.document.block.LytImage;
import guideme.document.flow.InlineBlockAlignment;
import guideme.document.flow.LytFlowContent;
import guideme.document.flow.LytFlowInlineBlock;
import guideme.document.flow.LytFlowParent;
import guideme.libs.mdast.mdx.model.MdxJsxElementFields;
import guideme.libs.unist.UnistNode;
import java.util.Set;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MarginFloatingImageCompiler
extends FlowTagCompiler {
    private static final Logger LOG = LoggerFactory.getLogger(MarginFloatingImageCompiler.class);

    public Set<String> getTagNames() {
        return Set.of("MarginFloatingImage");
    }

    protected void compile(PageCompiler compiler, LytFlowParent parent, MdxJsxElementFields el) {
        String src = el.getAttributeString("src", null);
        String align = el.getAttributeString("align", "left");
        String title = el.getAttributeString("title", null);
        int marginLeft = MdxAttrs.getInt((PageCompiler)compiler, (LytErrorSink)parent, (MdxJsxElementFields)el, (String)"left", (int)5);
        int marginTop = MdxAttrs.getInt((PageCompiler)compiler, (LytErrorSink)parent, (MdxJsxElementFields)el, (String)"top", (int)5);
        int marginRight = MdxAttrs.getInt((PageCompiler)compiler, (LytErrorSink)parent, (MdxJsxElementFields)el, (String)"right", (int)5);
        int marginBottom = MdxAttrs.getInt((PageCompiler)compiler, (LytErrorSink)parent, (MdxJsxElementFields)el, (String)"bottom", (int)5);
        LytImage image = new LytImage();
        if (title != null) {
            image.setTitle(title);
        }
        try {
            ResourceLocation imageId = IdUtils.resolveLink((String)src, (ResourceLocation)compiler.getPageId());
            byte[] imageContent = compiler.loadAsset(imageId);
            if (imageContent == null) {
                LOG.error("Couldn't find image {}", (Object)src);
                image.setTitle("Missing image: " + src);
            }
            image.setImage(imageId, imageContent);
        }
        catch (ResourceLocationException e) {
            LOG.error("Invalid image id: {}", (Object)src);
            image.setTitle("Invalid image URL: " + src);
        }
        image.setMarginLeft(marginLeft);
        image.setMarginTop(marginTop);
        image.setMarginRight(marginRight);
        image.setMarginBottom(marginBottom);
        LytFlowInlineBlock inlineBlock = new LytFlowInlineBlock();
        inlineBlock.setBlock((LytBlock)image);
        switch (align) {
            case "left": {
                inlineBlock.setAlignment(InlineBlockAlignment.FLOAT_LEFT);
                break;
            }
            case "right": {
                inlineBlock.setAlignment(InlineBlockAlignment.FLOAT_RIGHT);
                break;
            }
            default: {
                parent.append(compiler.createErrorFlowContent("Invalid align. Must be left or right.", (UnistNode)el));
                return;
            }
        }
        parent.append((LytFlowContent)inlineBlock);
    }

    public void index(IndexingContext indexer, MdxJsxElementFields el, IndexingSink sink) {
        String title = el.getAttributeString("title", null);
        if (title != null) {
            sink.appendText((UnistNode)el, title);
        }
    }
}

