/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone;

import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.LBRBlocks;
import net.swedz.little_big_redstone.LBRItems;
import net.swedz.little_big_redstone.block.microchip.MicrochipBlock;
import net.swedz.little_big_redstone.microchip.object.logic.LogicType;
import net.swedz.little_big_redstone.microchip.object.logic.LogicTypes;
import net.swedz.tesseract.neoforge.registry.holder.ItemHolder;

public final class LBRCreativeTabs {
    private static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"little_big_redstone");
    public static final Supplier<CreativeModeTab> CREATIVE_TAB = CREATIVE_MODE_TABS.register("little_big_redstone", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)LBR.id("little_big_redstone").toLanguageKey("itemGroup"))).icon(() -> ((MicrochipBlock)LBRBlocks.microchip(DyeColor.RED).get()).asItem().getDefaultInstance()).displayItems((params, output) -> {
        Comparator<ItemHolder> compareBySortOrder = Comparator.comparing(ItemHolder::sortOrder);
        Comparator<ItemHolder> compareByName = Comparator.comparing(i -> i.identifier().id());
        LBRItems.values().stream().sorted(compareBySortOrder.thenComparing(compareByName)).forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0));
    }).build());
    private static final Supplier<List<ItemStack>> LOGIC_ARRAY_ITEMS = Suppliers.memoize(() -> {
        ArrayList items = Lists.newArrayList();
        items.add(LBRItems.REDSTONE_BIT.asItem().getDefaultInstance());
        for (LogicType<?> type : LogicTypes.values()) {
            ItemStack stack = type.toStack(type.defaultFactory().create());
            items.add(stack);
        }
        return Collections.unmodifiableList(items);
    });

    public static List<ItemStack> getLogicArrayItems() {
        return LOGIC_ARRAY_ITEMS.get();
    }

    public static void init(IEventBus bus) {
        CREATIVE_MODE_TABS.register(bus);
    }
}

