/*
 * Decompiled with CFR 0.152.
 */
package dev.kleinbox.cccbridge.common.create.display;

import com.simibubi.create.api.behaviour.display.DisplayTarget;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.target.DisplayBoardTarget;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import dan200.computercraft.core.terminal.Terminal;
import dev.kleinbox.cccbridge.common.assistance.CharsetManipulator;
import dev.kleinbox.cccbridge.common.minecraft.blockEntity.TargetBlockEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TargetBlockDisplayTarget
extends DisplayBoardTarget {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptFlapText(int offset, List<List<MutableComponent>> text, DisplayLinkContext context) {
        BlockEntity blockEntity = context.getTargetBlockEntity();
        if (!(blockEntity instanceof TargetBlockEntity)) {
            return;
        }
        TargetBlockEntity target = (TargetBlockEntity)blockEntity;
        Terminal term = target.getPeripheral(null).term;
        ArrayList<String> source = new ArrayList<String>();
        for (List<MutableComponent> line : text) {
            StringBuilder parts = new StringBuilder();
            for (MutableComponent sLine : line) {
                parts.append(sLine.getString()).append(" ");
            }
            source.add(CharsetManipulator.toCCTxt(parts.toString()));
        }
        Terminal terminal = term;
        synchronized (terminal) {
            term.clear();
            int y = offset;
            for (String line : source) {
                term.setCursorPos(0, y);
                ++y;
                term.write(line);
            }
        }
    }

    public DisplayTargetStats provideStats(DisplayLinkContext context) {
        BlockEntity block = context.getTargetBlockEntity();
        if (!(block instanceof TargetBlockEntity)) {
            return new DisplayTargetStats(1, 1, (DisplayTarget)this);
        }
        TargetBlockEntity targetBlock = (TargetBlockEntity)block;
        Terminal term = targetBlock.getPeripheral(null).term;
        return new DisplayTargetStats(term.getHeight(), term.getWidth(), (DisplayTarget)this);
    }
}

