/*
 * Decompiled with CFR 0.152.
 */
package dev.kleinbox.cccbridge.common.computercraft.peripherals;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.core.terminal.TextBuffer;
import dev.kleinbox.cccbridge.common.computercraft.TweakedPeripheral;
import dev.kleinbox.cccbridge.common.minecraft.blockEntity.TargetBlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TargetBlockPeripheral
implements TweakedPeripheral<TargetBlockEntity> {
    private final TargetBlockEntity be;
    public final Terminal term = new Terminal(32, 8, true);

    public static double getVersion() {
        return 1.2;
    }

    public TargetBlockPeripheral(TargetBlockEntity be) {
        this.be = be;
    }

    @LuaFunction
    public final void resize(int width, int height) throws LuaException {
        if (width < 1 || height < 1) {
            throw new LuaException("The width and height of the terminal must be bigger than zero.");
        }
        this.term.resize(width, height);
    }

    @LuaFunction
    public final String getLine(int y) throws LuaException {
        if (y < 1 || y > this.term.getHeight()) {
            throw new LuaException("Expected number in range 1-" + this.term.getHeight());
        }
        TextBuffer line = this.term.getLine(y - 1);
        return line.toString();
    }

    @LuaFunction
    public final String[] dump() {
        int height = this.term.getHeight();
        String[] dump = new String[height];
        for (int i = 0; i < height; ++i) {
            dump[i] = this.term.getLine(i).toString();
        }
        return dump;
    }

    @LuaFunction
    public final Object[] getSize() {
        return new Object[]{this.term.getWidth(), this.term.getHeight()};
    }

    @Override
    @NotNull
    public String getType() {
        return "create_target";
    }

    @Override
    @Nullable
    public TargetBlockEntity getTarget() {
        return this.be;
    }
}

