/*
 * Decompiled with CFR 0.152.
 */
package dev.kleinbox.cccbridge.common.computercraft.peripherals;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.core.computer.ComputerSide;
import dev.kleinbox.cccbridge.common.computercraft.TweakedPeripheral;
import dev.kleinbox.cccbridge.common.minecraft.blockEntity.RedRouterBlockEntity;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedRouterBlockPeripheral
implements TweakedPeripheral<RedRouterBlockEntity> {
    private final RedRouterBlockEntity be;
    public static final String REDSTONE_EVENT = "redstone";

    public static double getVersion() {
        return 1.0;
    }

    public RedRouterBlockPeripheral(RedRouterBlockEntity blockentity) {
        this.be = blockentity;
    }

    public Direction getActualSide(ComputerSide side) {
        RedRouterBlockEntity be = this.getTarget();
        if (be != null) {
            Direction facing = this.getTarget().getFacing();
            return switch (side.getName()) {
                case "front" -> facing.getOpposite();
                case "back" -> facing;
                case "left" -> facing.getClockWise();
                case "right" -> facing.getCounterClockWise();
                case "top" -> Direction.DOWN;
                case "bottom" -> Direction.UP;
                default -> Direction.NORTH;
            };
        }
        return Direction.NORTH;
    }

    @LuaFunction
    public final void setOutput(ComputerSide side, boolean on) {
        RedRouterBlockEntity be = this.getTarget();
        if (be != null) {
            be.setPower(this.getActualSide(side).getName(), on ? 15 : 0);
        }
    }

    @LuaFunction
    public final boolean getOutput(ComputerSide side) {
        RedRouterBlockEntity be = this.getTarget();
        if (be != null) {
            return be.getPower(this.getActualSide(side)) > 0;
        }
        return false;
    }

    @LuaFunction
    public final boolean getInput(ComputerSide side) {
        RedRouterBlockEntity be = this.getTarget();
        if (be != null) {
            return be.getRedstoneInput(this.getActualSide(side)) > 0;
        }
        return false;
    }

    @LuaFunction(value={"setAnalogOutput", "setAnalogueOutput"})
    public final void setAnalogOutput(ComputerSide side, int value) throws LuaException {
        if (value < 0 || value > 15) {
            throw new LuaException("Expected number in range 0-15");
        }
        RedRouterBlockEntity be = this.getTarget();
        if (be != null) {
            be.setPower(this.getActualSide(side).getName(), value);
        }
    }

    @LuaFunction(value={"getAnalogOutput", "getAnalogueOutput"})
    public final int getAnalogOutput(ComputerSide side) {
        RedRouterBlockEntity be = this.getTarget();
        if (be != null) {
            return be.getPower(this.getActualSide(side));
        }
        return 0;
    }

    @LuaFunction(value={"getAnalogInput", "getAnalogueInput"})
    public final int getAnalogInput(ComputerSide side) {
        RedRouterBlockEntity be = this.getTarget();
        if (be != null) {
            return be.getRedstoneInput(this.getActualSide(side));
        }
        return 0;
    }

    @Override
    @NotNull
    public String getType() {
        return "redrouter";
    }

    @Override
    @Nullable
    public RedRouterBlockEntity getTarget() {
        return this.be;
    }
}

