/*
 * Decompiled with CFR 0.152.
 */
package com.mcwfurnitures.kikoz.objects;

import com.mcwfurnitures.kikoz.objects.FurnitureObjectNonFaceable;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Table
extends FurnitureObjectNonFaceable {
    public static final EnumProperty<ConnectionStatus> CONNECTION = EnumProperty.create((String)"connection", ConnectionStatus.class);
    protected static final VoxelShape BASE = Shapes.or((VoxelShape)Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)14.0, (double)10.0));
    protected static final VoxelShape MIDDLE = Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public Table(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(CONNECTION, (Comparable)((Object)ConnectionStatus.WITH_LEG)));
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext contx) {
        switch (((ConnectionStatus)((Object)state.getValue(CONNECTION))).ordinal()) {
            case 0: {
                return MIDDLE;
            }
            case 1: {
                return BASE;
            }
        }
        return BASE;
    }

    private BlockState TableState(BlockState state, LevelAccessor access, BlockPos pos) {
        boolean north = access.getBlockState(pos.north()).getBlock() == this;
        boolean east = access.getBlockState(pos.east()).getBlock() == this;
        boolean south = access.getBlockState(pos.south()).getBlock() == this;
        boolean west = access.getBlockState(pos.west()).getBlock() == this;
        ConnectionStatus connection = this.getConnectionStatus(north, east, south, west);
        return (BlockState)state.setValue(CONNECTION, (Comparable)((Object)connection));
    }

    private ConnectionStatus getConnectionStatus(boolean north, boolean east, boolean south, boolean west) {
        if (north && south && !east && !west) {
            return ConnectionStatus.CENTER;
        }
        if (!north && !south && east && west) {
            return ConnectionStatus.CENTER;
        }
        if (north && east && west && south) {
            return ConnectionStatus.CENTER;
        }
        if (north && east && !west && south) {
            return ConnectionStatus.CENTER;
        }
        if (!north && east && west && south) {
            return ConnectionStatus.CENTER;
        }
        if (north && !east && west && south) {
            return ConnectionStatus.CENTER;
        }
        if (north && east && west && !south) {
            return ConnectionStatus.CENTER;
        }
        if (north && !east && !west && south) {
            return ConnectionStatus.WITH_LEG;
        }
        if (!north && east && west && !south) {
            return ConnectionStatus.WITH_LEG;
        }
        if (north && !east && west && !south) {
            return ConnectionStatus.WITH_LEG;
        }
        if (north && east && !west && !south) {
            return ConnectionStatus.WITH_LEG;
        }
        if (!north && east && !west && south) {
            return ConnectionStatus.WITH_LEG;
        }
        if (!north && !east && west && south) {
            return ConnectionStatus.WITH_LEG;
        }
        if (north && !east && !west && !south) {
            return ConnectionStatus.WITH_LEG;
        }
        if (!north && east && !west && !south) {
            return ConnectionStatus.WITH_LEG;
        }
        if (!north && !east && !west && south) {
            return ConnectionStatus.WITH_LEG;
        }
        if (!north && !east && west && !south) {
            return ConnectionStatus.WITH_LEG;
        }
        return ConnectionStatus.WITH_LEG;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity livent, ItemStack stack) {
        this.TableState(state, (LevelAccessor)level, pos);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState statetwo, boolean bolean) {
        if (!statetwo.is(state.getBlock())) {
            this.TableState(state, (LevelAccessor)level, pos);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{CONNECTION});
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        return this.TableState(state, level, pos);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.TableState(super.getStateForPlacement(context), (LevelAccessor)context.getLevel(), context.getClickedPos());
    }

    public void placeAt(Level level, BlockPos pos, int number) {
        level.setBlock(pos, this.defaultBlockState(), number);
    }

    public static enum ConnectionStatus implements StringRepresentable
    {
        CENTER("center"),
        WITH_LEG("with_leg");

        private final String name;

        private ConnectionStatus(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

