/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.mixin.flw;

import com.mojang.blaze3d.vertex.MeshData;
import dev.djefrey.colorwheel.engine.IrisTerrainVertexView;
import dev.engine_room.flywheel.api.vertex.VertexList;
import dev.engine_room.flywheel.lib.memory.MemoryBlock;
import dev.engine_room.flywheel.lib.model.SimpleQuadMesh;
import java.nio.ByteBuffer;
import net.irisshaders.iris.vertices.IrisVertexFormats;
import org.lwjgl.system.MemoryUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(targets={"dev/engine_room/flywheel/lib/model/baked/MeshHelper"})
public class MeshHelperMixin {
    @Inject(method={"blockVerticesToMesh(Lcom/mojang/blaze3d/vertex/MeshData;Ljava/lang/String;)Ldev/engine_room/flywheel/lib/model/SimpleQuadMesh;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void injectCustomVertexData(MeshData data, String meshDescriptor, CallbackInfoReturnable<SimpleQuadMesh> cir) {
        if (data.drawState().format() == IrisVertexFormats.TERRAIN) {
            MeshData.DrawState drawState = data.drawState();
            int vertexCount = drawState.vertexCount();
            long srcStride = drawState.format().getVertexSize();
            IrisTerrainVertexView vertexView = new IrisTerrainVertexView();
            long dstStride = vertexView.stride();
            ByteBuffer src = data.vertexBuffer();
            MemoryBlock dst = MemoryBlock.mallocTracked((long)((long)vertexCount * dstStride));
            long srcPtr = MemoryUtil.memAddress((ByteBuffer)src);
            long dstPtr = dst.ptr();
            MemoryUtil.memCopy((long)srcPtr, (long)dstPtr, (long)(srcStride * (long)vertexCount));
            vertexView.ptr(dstPtr);
            vertexView.vertexCount(vertexCount);
            vertexView.nativeMemoryOwner(dst);
            cir.setReturnValue((Object)new SimpleQuadMesh((VertexList)vertexView, meshDescriptor));
        }
    }
}

