/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.engine.uniform;

import dev.djefrey.colorwheel.compile.ClrwlProgram;
import dev.djefrey.colorwheel.engine.ShadowRenderContext;
import dev.djefrey.colorwheel.engine.uniform.ClrwlFrameUniforms;
import dev.djefrey.colorwheel.engine.uniform.ClrwlLevelUniforms;
import dev.djefrey.colorwheel.engine.uniform.ClrwlOptionsUniforms;
import dev.djefrey.colorwheel.engine.uniform.ClrwlShadowFrameUniforms;
import dev.engine_room.flywheel.api.backend.RenderContext;
import net.irisshaders.iris.shaderpack.ShaderPack;
import net.irisshaders.iris.shaderpack.materialmap.NamespacedId;

public class ClrwlUniforms {
    public static final int FRAME_INDEX = 0;
    public static final int LEVEL_INDEX = 1;
    public static final int OPTIONS_INDEX = 2;
    public static final String FRAME_BLOCK_NAME = "_ClrwlFrameUniforms";
    public static final String LEVEL_BLOCK_NAME = "_ClrwlLevelUniforms";
    public static final String OPTIONS_BLOCK_NAME = "_ClrwlOptionsUniforms";

    public static void update(RenderContext context, ShaderPack pack, NamespacedId dimension) {
        if (context instanceof ShadowRenderContext) {
            ShadowRenderContext shadowContext = (ShadowRenderContext)context;
            ClrwlShadowFrameUniforms.update(shadowContext);
        } else {
            ClrwlFrameUniforms.update(context, pack, dimension);
        }
        ClrwlLevelUniforms.update(context);
    }

    public static void bind(boolean isShadow) {
        if (isShadow) {
            ClrwlUniforms.bindShadow();
        } else {
            ClrwlUniforms.bindColor();
        }
    }

    public static void bindColor() {
        ClrwlFrameUniforms.BUFFER.bind();
        ClrwlLevelUniforms.BUFFER.bind();
        ClrwlOptionsUniforms.BUFFER.bind();
    }

    public static void bindShadow() {
        ClrwlShadowFrameUniforms.BUFFER.bind();
        ClrwlLevelUniforms.BUFFER.bind();
        ClrwlOptionsUniforms.BUFFER.bind();
    }

    public static void setUniformBlockBinding(ClrwlProgram program) {
        program.setUniformBlockBinding(FRAME_BLOCK_NAME, 0);
        program.setUniformBlockBinding(LEVEL_BLOCK_NAME, 1);
        program.setUniformBlockBinding(OPTIONS_BLOCK_NAME, 2);
    }
}

