/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.engine;

import dev.djefrey.colorwheel.engine.ClrwlAbstractInstancer;
import dev.djefrey.colorwheel.engine.ClrwlInstanceHandle;
import dev.djefrey.colorwheel.engine.ClrwlInstancerKey;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.instance.InstanceHandle;
import dev.engine_room.flywheel.backend.util.AtomicBitSet;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public abstract class ClrwlBaseInstancer<I extends Instance>
extends ClrwlAbstractInstancer<I>
implements ClrwlInstanceHandle.State<I> {
    protected final Object lock = new Object();
    protected final ArrayList<I> instances = new ArrayList();
    protected final ArrayList<ClrwlInstanceHandle<I>> handles = new ArrayList();
    protected final AtomicBitSet changed = new AtomicBitSet();
    protected final AtomicBitSet deleted = new AtomicBitSet();

    protected ClrwlBaseInstancer(ClrwlInstancerKey<I> key, ClrwlAbstractInstancer.Recreate<I> recreate) {
        super(key, recreate);
    }

    @Override
    public ClrwlInstanceHandle.State<I> setChanged(int index) {
        this.notifyDirty(index);
        return this;
    }

    @Override
    public ClrwlInstanceHandle.State<I> setDeleted(int index) {
        this.notifyRemoval(index);
        return ClrwlInstanceHandle.Deleted.instance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClrwlInstanceHandle.State<I> setVisible(ClrwlInstanceHandle<I> handle, int index, boolean visible) {
        Instance instance;
        if (visible) {
            return this;
        }
        this.notifyRemoval(index);
        Object object = this.lock;
        synchronized (object) {
            instance = (Instance)this.instances.get(index);
        }
        return new ClrwlInstanceHandle.Hidden<Instance>(this.recreate, instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I createInstance() {
        ClrwlInstanceHandle handle = new ClrwlInstanceHandle(this);
        Instance instance = this.type.create(handle);
        Object object = this.lock;
        synchronized (object) {
            handle.index = this.instances.size();
            this.addLocked(instance, handle);
            return (I)instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClrwlInstanceHandle.State<I> revealInstance(ClrwlInstanceHandle<I> handle, I instance) {
        Object object = this.lock;
        synchronized (object) {
            handle.index = this.instances.size();
            this.addLocked(instance, handle);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stealInstance(@Nullable I instance) {
        ClrwlInstanceHandle.Hidden hidden;
        if (instance == null) {
            return;
        }
        InstanceHandle instanceHandle = instance.handle();
        if (!(instanceHandle instanceof ClrwlInstanceHandle)) {
            return;
        }
        ClrwlInstanceHandle handle = (ClrwlInstanceHandle)instanceHandle;
        if (handle.state == this) {
            return;
        }
        if (handle.state instanceof ClrwlInstanceHandle.Deleted) {
            return;
        }
        ClrwlInstanceHandle.State state = handle.state;
        if (state instanceof ClrwlInstanceHandle.Hidden && this.recreate.equals((hidden = (ClrwlInstanceHandle.Hidden)state).recreate())) {
            return;
        }
        state = handle.state;
        if (state instanceof ClrwlBaseInstancer) {
            ClrwlBaseInstancer other = (ClrwlBaseInstancer)state;
            other.notifyRemoval(handle.index);
            handle.state = this;
            state = this.lock;
            synchronized (state) {
                handle.index = this.instances.size();
                this.addLocked(instance, handle);
            }
        } else if (handle.state instanceof ClrwlInstanceHandle.Hidden) {
            handle.state = new ClrwlInstanceHandle.Hidden<I>(this.recreate, instance);
        }
    }

    private void addLocked(I instance, ClrwlInstanceHandle<I> handle) {
        this.instances.add(instance);
        this.handles.add(handle);
        this.setIndexChanged(handle.index);
    }

    @Override
    public int instanceCount() {
        return this.instances.size();
    }

    public void notifyDirty(int index) {
        if (index < 0 || index >= this.instanceCount()) {
            return;
        }
        this.setIndexChanged(index);
    }

    protected void setIndexChanged(int index) {
        this.changed.set(index);
    }

    public void notifyRemoval(int index) {
        if (index < 0 || index >= this.instanceCount()) {
            return;
        }
        this.deleted.set(index);
    }

    @Override
    public void clear() {
        for (ClrwlInstanceHandle<I> handle : this.handles) {
            if (handle.state != this) continue;
            handle.clear();
            handle.state = ClrwlInstanceHandle.Deleted.instance();
        }
        this.instances.clear();
        this.handles.clear();
        this.changed.clear();
        this.deleted.clear();
    }
}

