/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.compile.oit;

import dev.djefrey.colorwheel.Colorwheel;
import dev.djefrey.colorwheel.engine.ClrwlOitAccumulateOverride;
import dev.djefrey.colorwheel.util.Utils;
import dev.engine_room.flywheel.backend.glsl.SourceComponent;
import dev.engine_room.flywheel.backend.glsl.generate.FnSignature;
import dev.engine_room.flywheel.backend.glsl.generate.GlslBlock;
import dev.engine_room.flywheel.backend.glsl.generate.GlslBuilder;
import dev.engine_room.flywheel.backend.glsl.generate.GlslStmt;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class OitEvaluateComponent
implements SourceComponent {
    private int[] drawBuffers;
    private int[] ranks;
    private List<ClrwlOitAccumulateOverride> overrides;
    private Map<Integer, String> shaderOutputs;

    public OitEvaluateComponent(int[] drawBuffers, int[] ranks, List<ClrwlOitAccumulateOverride> overrides, Map<Integer, String> shaderOutputs) {
        this.drawBuffers = drawBuffers;
        this.ranks = ranks;
        this.overrides = overrides;
        this.shaderOutputs = shaderOutputs;
    }

    public Collection<? extends SourceComponent> included() {
        return List.of();
    }

    public String source() {
        GlslBuilder builder = new GlslBuilder();
        GlslBlock body = new GlslBlock();
        body.add(GlslStmt.raw((String)"float linearDepth = _clrwl_linear_depth();"));
        body.add(GlslStmt.raw((String)"vec2 depthRange = texelFetch(_flw_depthRange, ivec2(gl_FragCoord.xy), 0).rg;"));
        body.add(GlslStmt.raw((String)"float delta = depthRange.x + depthRange.y;"));
        body.add(GlslStmt.raw((String)"float flw_depth = (linearDepth + depthRange.x) / delta;"));
        body.add(GlslStmt.raw((String)"float depth_adjustment = _clrwl_tented_blue_noise(flw_depth) * _flw_oitNoise;"));
        body.add(GlslStmt.raw((String)""));
        String transmittance_from_depth = "depth_transmittance";
        body.add(GlslStmt.raw((String)("float " + transmittance_from_depth + " = _clrwl_frontmost_transmittance_from_depth(linearDepth, depthRange);")));
        for (int i = 0; i < this.drawBuffers.length; ++i) {
            int drawBuffer = this.drawBuffers[i];
            String outName = this.shaderOutputs.get(i);
            Optional maybeCoeffId = Utils.findFirst(this.overrides, e -> e.drawBuffer() == drawBuffer).flatMap(ClrwlOitAccumulateOverride::coefficientId);
            if (maybeCoeffId.isPresent()) {
                int coeffId = (Integer)maybeCoeffId.get();
                int rank = this.ranks[coeffId];
                String transmittance = "transmittance" + drawBuffer;
                String coeffs = "clrwl_coefficients" + coeffId;
                String depth = "depth" + drawBuffer;
                String correctedTransmittance = "correctedTransmittance" + drawBuffer;
                body.add(GlslStmt.raw((String)("float " + transmittance + " = 1. - " + outName + ".a;")));
                body.add(GlslStmt.raw((String)("float " + depth + " = flw_depth;")));
                body.add(GlslStmt.raw((String)("if (" + transmittance + " > 1e-5) { " + depth + " -= depth_adjustment; }")));
                body.add(GlslStmt.raw((String)("float " + correctedTransmittance + " = _clrwl_signal_corrected_transmittance(" + coeffs + ", " + depth + ", " + transmittance + ", " + rank + ");")));
                body.add(GlslStmt.raw((String)(outName + ".rgb *= " + outName + ".a;")));
                body.add(GlslStmt.raw((String)(outName + " *= " + correctedTransmittance + ";")));
                continue;
            }
            body.add(GlslStmt.raw((String)(outName + " *= " + transmittance_from_depth + ";")));
        }
        builder.function().signature(FnSignature.create().returnType("void").name("_clrwl_post_shader").build()).body(body);
        return builder.build();
    }

    public String name() {
        return Colorwheel.rl("oit_evaluate").toString();
    }
}

