/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.server.sync;

import com.github.jarva.arsadditions.common.block.tile.EnderSourceJarTile;
import com.github.jarva.arsadditions.server.storage.EnderSourceData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SourceJarSync {
    public static Map<ResourceKey<Level>, Set<BlockPos>> posMap = new ConcurrentHashMap<ResourceKey<Level>, Set<BlockPos>>();

    public static void addPosition(Level world, BlockPos pos) {
        ResourceKey key = world.dimension();
        posMap.computeIfAbsent((ResourceKey<Level>)key, k -> new HashSet()).add(pos);
    }

    public static void updateSourceLevel(MinecraftServer server, UUID uuid) {
        int source = EnderSourceData.getSource(server, uuid);
        for (Map.Entry<ResourceKey<Level>, Set<BlockPos>> entry : posMap.entrySet()) {
            ServerLevel world = server.getLevel(entry.getKey());
            if (world == null) continue;
            Set<BlockPos> positions = entry.getValue();
            ArrayList<BlockPos> stale = new ArrayList<BlockPos>();
            for (BlockPos p : positions) {
                if (!world.isLoaded(p)) continue;
                BlockEntity entity = world.getBlockEntity(p);
                if (entity instanceof EnderSourceJarTile) {
                    EnderSourceJarTile tile = (EnderSourceJarTile)entity;
                    if (!tile.getOwner().equals(uuid) || tile.getSource() == source) continue;
                    tile.setSource(source);
                    continue;
                }
                stale.add(p);
            }
            for (BlockPos pos : stale) {
                positions.remove(pos);
            }
        }
    }
}

