/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.block;

import com.github.jarva.arsadditions.common.block.tile.SourceSpawnerTile;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.block.ITickableBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SourceSpawner
extends Block
implements EntityBlock,
ITickableBlock {
    public SourceSpawner() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(5.0f).sound(SoundType.METAL).noOcclusion().pushReaction(PushReaction.BLOCK));
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SourceSpawnerTile) {
            SourceSpawnerTile tile = (SourceSpawnerTile)blockEntity;
            tile.spawner.disabled = level.hasNeighborSignal(pos);
            BlockUtil.safelyUpdateState((Level)level, (BlockPos)pos);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SourceSpawnerTile) {
            SourceSpawnerTile tile = (SourceSpawnerTile)blockEntity;
            return tile.getDelaySignal();
        }
        return super.getAnalogOutputSignal(state, level, pos);
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new SourceSpawnerTile(pos, state);
    }
}

