/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.client.util;

import com.github.jarva.arsadditions.mixin.patchouli.BookEntryAccessor;
import com.github.jarva.arsadditions.mixin.patchouli.BookPageAccessor;
import com.github.jarva.arsadditions.mixin.patchouli.PageRelationsAccessor;
import com.github.jarva.arsadditions.mixin.patchouli.PageTextAccessor;
import com.hollingsworth.arsnouveau.ArsNouveau;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.BookPage;
import vazkii.patchouli.client.book.page.PageRelations;
import vazkii.patchouli.client.book.page.PageText;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;

public class BookUtil {
    public static final ResourceLocation WORN_NOTEBOOK = ArsNouveau.prefix((String)"worn_notebook");

    public static void addRelation(ResourceLocation bookEntry, ResourceLocation relation) {
        Map<ResourceLocation, BookEntry> entries = BookUtil.getEntries();
        BookEntry entry = entries.get(bookEntry);
        if (entry == null) {
            return;
        }
        List pages = entry.getPages();
        Optional<BookPage> relationsPage = pages.stream().filter(p -> p instanceof PageRelations).findFirst();
        relationsPage.ifPresent(relations -> {
            PageRelationsAccessor relationsAccessor = (PageRelationsAccessor)relations;
            relationsAccessor.getEntries().add((BookEntry)entries.get(relation));
        });
    }

    public static void addPage(ResourceLocation bookEntry, BookPage newPage) {
        BookUtil.addPage(bookEntry, newPage, true, null);
    }

    public static void addPage(ResourceLocation bookEntry, BookPage newPage, boolean after, @Nullable Predicate<BookPage> isPage) {
        int i;
        Map<ResourceLocation, BookEntry> entries = BookUtil.getEntries();
        BookEntry entry = entries.get(bookEntry);
        if (entry == null) {
            return;
        }
        BookEntryAccessor entryAccessor = (BookEntryAccessor)entry;
        List<BookPage> pages = entryAccessor.getRealPages();
        if (isPage == null) {
            i = pages.size() - 1;
        } else {
            for (i = 0; i < pages.size(); ++i) {
                BookPage followUp;
                BookPage page = pages.get(i);
                if (!isPage.test(page)) continue;
                if (!after) break;
                ++i;
                while (i < pages.size() && BookUtil.isBasicTextPage(followUp = pages.get(i))) {
                    ++i;
                }
                break;
            }
        }
        pages.add(i, newPage);
    }

    public static BookPage newTextPage(String title, String text) {
        PageText page = new PageText();
        PageTextAccessor pageTextAccessor = (PageTextAccessor)page;
        pageTextAccessor.setTitle(title);
        BookPageAccessor bookPageAccessor = (BookPageAccessor)page;
        bookPageAccessor.setPageNum(1);
        page.setText(text);
        return page;
    }

    public static boolean isTitlePage(BookPage page, String pageTitle) {
        String title = BookUtil.getTitle(page);
        return title != null && title.equals(pageTitle);
    }

    public static String getTitle(BookPage page) {
        if (page instanceof PageText) {
            PageText text = (PageText)page;
            PageTextAccessor textAccessor = (PageTextAccessor)text;
            return textAccessor.getTitle();
        }
        return null;
    }

    public static boolean isBasicTextPage(BookPage page) {
        if (page instanceof PageText) {
            PageText text = (PageText)page;
            return BookUtil.getTitle((BookPage)text) == null;
        }
        return false;
    }

    private static Map<ResourceLocation, BookEntry> getEntries() {
        Book wornNotebook = (Book)BookRegistry.INSTANCE.books.get(WORN_NOTEBOOK);
        return wornNotebook.getContents().entries;
    }
}

