/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.generators;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.base.block.MultiblockMachine;
import rearth.oritech.block.base.block.PassiveGeneratorBlock;
import rearth.oritech.block.entity.generators.BigSolarPanelEntity;
import rearth.oritech.util.MultiblockMachineController;
import rearth.oritech.util.TooltipHelper;

public class BigSolarPanelBlock
extends PassiveGeneratorBlock {
    public final int productionRate;

    public BigSolarPanelBlock(BlockBehaviour.Properties settings, int productionRate) {
        super(settings);
        this.productionRate = productionRate;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)MultiblockMachine.ASSEMBLED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{MultiblockMachine.ASSEMBLED});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BigSolarPanelEntity(pos, state);
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (!world.isClientSide) {
            Boolean corePlaced;
            BlockEntity entity = world.getBlockEntity(pos);
            if (!(entity instanceof BigSolarPanelEntity)) {
                return InteractionResult.SUCCESS;
            }
            BigSolarPanelEntity solarPanel = (BigSolarPanelEntity)entity;
            Boolean wasAssembled = (Boolean)state.getValue((Property)MultiblockMachine.ASSEMBLED);
            if (!wasAssembled.booleanValue() && (corePlaced = solarPanel.tryPlaceNextCore(player)).booleanValue()) {
                return InteractionResult.SUCCESS;
            }
            boolean isAssembled = solarPanel.initMultiblock(state);
            if (isAssembled && !wasAssembled.booleanValue()) {
                solarPanel.triggerSetupAnimation();
                return InteractionResult.SUCCESS;
            }
            if (!isAssembled) {
                player.sendSystemMessage((Component)Component.translatable((String)"message.oritech.machine.missing_core"));
            } else {
                solarPanel.sendInfoMessageToPlayer(player);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        BlockEntity entity;
        if (!world.isClientSide() && ((Boolean)state.getValue((Property)MultiblockMachine.ASSEMBLED)).booleanValue() && (entity = world.getBlockEntity(pos)) instanceof MultiblockMachineController) {
            MultiblockMachineController machineEntity = (MultiblockMachineController)entity;
            machineEntity.onControllerBroken();
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag options) {
        super.appendHoverText(stack, context, tooltip, options);
        TooltipHelper.addMachineTooltip(tooltip, this, this);
        if (Screen.hasControlDown()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.oritech.solar_generation").withStyle(ChatFormatting.GRAY));
        }
    }
}

