/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.util;

import dev.su5ed.mffs.api.fortron.FortronStorage;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.fml.util.thread.EffectiveSide;
import one.util.streamex.StreamEx;

public class FrequencyGrid {
    private static FrequencyGrid CLIENT_INSTANCE = new FrequencyGrid();
    private static FrequencyGrid SERVER_INSTANCE = new FrequencyGrid();
    private final Set<FortronStorage> frequencyGrid = new HashSet<FortronStorage>();

    public <T extends FortronStorage> void register(T fortron) {
        BlockPos pos = fortron.getOwner().getBlockPos();
        this.frequencyGrid.removeIf(frequency -> {
            BlockEntity owner = frequency.getOwner();
            return frequency == null || owner.isRemoved() || owner.getBlockPos().equals((Object)pos);
        });
        this.frequencyGrid.add(fortron);
    }

    public static FrequencyGrid instance() {
        return FrequencyGrid.instance(EffectiveSide.get().isClient());
    }

    public static FrequencyGrid instance(boolean client) {
        return client ? CLIENT_INSTANCE : SERVER_INSTANCE;
    }

    public void unregister(FortronStorage tileEntity) {
        this.frequencyGrid.remove(tileEntity);
        this.cleanUp();
    }

    public Set<FortronStorage> get() {
        return this.frequencyGrid;
    }

    public Set<FortronStorage> get(int frequency) {
        return ((StreamEx)StreamEx.of(this.get()).filter(fortron -> fortron != null && !fortron.getOwner().isRemoved() && fortron.getFrequency() == frequency)).toSet();
    }

    public List<FortronStorage> get(Level level, Vec3i position, int radius, int frequency) {
        return ((StreamEx)StreamEx.of(this.get(frequency)).filter(fortron -> {
            BlockEntity owner = fortron.getOwner();
            return owner.getLevel() == level && position.closerThan((Vec3i)owner.getBlockPos(), (double)radius);
        })).toList();
    }

    public void cleanUp() {
        this.frequencyGrid.removeIf(fortron -> fortron == null || fortron.getOwner().isRemoved());
    }

    public static void reinitiate() {
        CLIENT_INSTANCE = new FrequencyGrid();
        SERVER_INSTANCE = new FrequencyGrid();
    }
}

