/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.setup;

import dev.su5ed.mffs.block.BaseEntityBlock;
import dev.su5ed.mffs.block.BiometricIdentifierBlock;
import dev.su5ed.mffs.block.CoercionDeriverBlock;
import dev.su5ed.mffs.block.ForceFieldBlockImpl;
import dev.su5ed.mffs.block.FortronCapacitorBlock;
import dev.su5ed.mffs.block.ProjectorBlock;
import dev.su5ed.mffs.blockentity.BaseBlockEntity;
import dev.su5ed.mffs.setup.ModObjects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class ModBlocks {
    private static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"mffs");
    private static final BlockBehaviour.Properties BLOCK_PROPERTIES = BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(3.0f).requiresCorrectToolForDrops();
    public static final DeferredBlock<ProjectorBlock> PROJECTOR = ModBlocks.block("projector", ProjectorBlock::new);
    public static final DeferredBlock<CoercionDeriverBlock> COERCION_DERIVER = ModBlocks.block("coercion_deriver", CoercionDeriverBlock::new);
    public static final DeferredBlock<FortronCapacitorBlock> FORTRON_CAPACITOR = ModBlocks.block("fortron_capacitor", FortronCapacitorBlock::new);
    public static final DeferredBlock<ForceFieldBlockImpl> FORCE_FIELD = BLOCKS.register("force_field", ForceFieldBlockImpl::new);
    public static final DeferredBlock<BiometricIdentifierBlock> BIOMETRIC_IDENTIFIER = ModBlocks.block("biometric_identifier", BiometricIdentifierBlock::new);
    public static final DeferredBlock<BaseEntityBlock> INTERDICTION_MATRIX = ModBlocks.baseEntityBlock("interdiction_matrix", () -> ModObjects.INTERDICTION_MATRIX_BLOCK_ENTITY);

    public static void init(IEventBus bus) {
        BLOCKS.register(bus);
    }

    private static DeferredBlock<BaseEntityBlock> baseEntityBlock(String name, Supplier<Supplier<? extends BlockEntityType<? extends BaseBlockEntity>>> beTypeProvider) {
        return BLOCKS.register(name, () -> new BaseEntityBlock(BLOCK_PROPERTIES, (Supplier)beTypeProvider.get()));
    }

    private static <T extends Block> DeferredBlock<T> block(String name, Function<BlockBehaviour.Properties, T> factory) {
        return BLOCKS.register(name, () -> (Block)factory.apply(BLOCK_PROPERTIES));
    }

    private ModBlocks() {
    }
}

