/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.api;

import codechicken.enderstorage.init.EnderStorageModContent;
import codechicken.lib.colour.EnumColour;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public record Frequency(EnumColour left, EnumColour middle, EnumColour right, Optional<UUID> owner, Optional<Component> ownerName) {
    public static final Codec<Frequency> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)EnumColour.CODEC.fieldOf("left").forGetter(Frequency::left), (App)EnumColour.CODEC.fieldOf("middle").forGetter(Frequency::middle), (App)EnumColour.CODEC.fieldOf("right").forGetter(Frequency::right), (App)UUIDUtil.CODEC.optionalFieldOf("owner").forGetter(Frequency::owner), (App)ComponentSerialization.CODEC.optionalFieldOf("ownerName").forGetter(Frequency::ownerName)).apply((Applicative)builder, Frequency::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Frequency> STREAM_CODEC = StreamCodec.composite((StreamCodec)EnumColour.STREAM_CODEC, Frequency::left, (StreamCodec)EnumColour.STREAM_CODEC, Frequency::middle, (StreamCodec)EnumColour.STREAM_CODEC, Frequency::right, (StreamCodec)ByteBufCodecs.optional((StreamCodec)UUIDUtil.STREAM_CODEC), Frequency::owner, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ComponentSerialization.STREAM_CODEC), Frequency::ownerName, Frequency::new);

    public Frequency() {
        this(EnumColour.WHITE, EnumColour.WHITE, EnumColour.WHITE);
    }

    public Frequency(EnumColour left, EnumColour middle, EnumColour right) {
        this(left, middle, right, Optional.empty(), Optional.empty());
    }

    @Deprecated
    public Frequency(CompoundTag tagCompound) {
        this(EnumColour.fromWoolMeta((int)tagCompound.getInt("left")), EnumColour.fromWoolMeta((int)tagCompound.getInt("middle")), EnumColour.fromWoolMeta((int)tagCompound.getInt("right")), tagCompound.hasUUID("owner") ? Optional.of(tagCompound.getUUID("owner")) : Optional.empty(), tagCompound.contains("owner_name") ? Optional.of(Component.Serializer.fromJson((String)tagCompound.getString("owner_name"), (HolderLookup.Provider)RegistryAccess.EMPTY)) : Optional.empty());
    }

    public Frequency withLeft(@Nullable EnumColour left) {
        if (left != null) {
            return new Frequency(left, this.middle, this.right, this.owner, this.ownerName);
        }
        return this;
    }

    public Frequency withMiddle(@Nullable EnumColour middle) {
        if (middle != null) {
            return new Frequency(this.left, middle, this.right, this.owner, this.ownerName);
        }
        return this;
    }

    public Frequency withRight(@Nullable EnumColour right) {
        if (right != null) {
            return new Frequency(this.left, this.middle, right, this.owner, this.ownerName);
        }
        return this;
    }

    public Frequency withOwner(Player player) {
        return new Frequency(this.left, this.middle, this.right, Optional.of(player.getUUID()), Optional.of(player.getName()));
    }

    public Frequency withoutOwner() {
        return new Frequency(this.left, this.middle, this.right, Optional.empty(), Optional.empty());
    }

    public boolean hasOwner() {
        return this.owner.isPresent() && this.ownerName.isPresent();
    }

    public Frequency withColours(@Nullable EnumColour[] colours) {
        return this.withLeft(colours[0]).withMiddle(colours[1]).withRight(colours[2]);
    }

    public EnumColour[] toArray() {
        return new EnumColour[]{this.left, this.middle, this.right};
    }

    private CompoundTag write_internal(CompoundTag tagCompound) {
        tagCompound.putInt("left", this.left.getWoolMeta());
        tagCompound.putInt("middle", this.middle.getWoolMeta());
        tagCompound.putInt("right", this.right.getWoolMeta());
        this.owner.ifPresent(uuid -> tagCompound.putUUID("owner", uuid));
        this.ownerName.ifPresent(component -> tagCompound.putString("owner_name", Component.Serializer.toJson((Component)component, (HolderLookup.Provider)RegistryAccess.EMPTY)));
        return tagCompound;
    }

    @Deprecated
    public void writeToPacket(MCDataOutput packet) {
        packet.writeCompoundNBT(this.write_internal(new CompoundTag()));
    }

    @Deprecated
    public static Frequency readFromPacket(MCDataInput packet) {
        return new Frequency(packet.readCompoundNBT());
    }

    @Deprecated
    public static Frequency readFromStack(ItemStack stack) {
        return (Frequency)stack.getOrDefault(EnderStorageModContent.FREQUENCY_DATA_COMPONENT, (Object)new Frequency());
    }

    @Deprecated
    public ItemStack writeToStack(ItemStack stack) {
        stack.set(EnderStorageModContent.FREQUENCY_DATA_COMPONENT, (Object)this);
        return stack;
    }

    @Override
    public String toString() {
        Object owner = "";
        if (this.hasOwner()) {
            owner = ",owner=" + String.valueOf(this.owner);
        }
        return "left=" + this.left().getSerializedName() + ",middle=" + this.middle().getSerializedName() + ",right=" + this.right().getSerializedName() + (String)owner;
    }

    public Component getTooltip() {
        return Component.translatable((String)this.left().getUnlocalizedName()).append("/").append((Component)Component.translatable((String)this.middle().getUnlocalizedName())).append("/").append((Component)Component.translatable((String)this.right().getUnlocalizedName()));
    }
}

