/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.init;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.block.AdvancedBeehive;
import cy.jdkdigital.productivebees.common.block.Amber;
import cy.jdkdigital.productivebees.common.block.BambooHive;
import cy.jdkdigital.productivebees.common.block.Bottler;
import cy.jdkdigital.productivebees.common.block.BreedingChamber;
import cy.jdkdigital.productivebees.common.block.CanvasBeehive;
import cy.jdkdigital.productivebees.common.block.CanvasExpansionBox;
import cy.jdkdigital.productivebees.common.block.Catcher;
import cy.jdkdigital.productivebees.common.block.Centrifuge;
import cy.jdkdigital.productivebees.common.block.ConfigurableCombBlock;
import cy.jdkdigital.productivebees.common.block.CryoStasis;
import cy.jdkdigital.productivebees.common.block.DragonEggHive;
import cy.jdkdigital.productivebees.common.block.ExpansionBox;
import cy.jdkdigital.productivebees.common.block.Feeder;
import cy.jdkdigital.productivebees.common.block.GeneIndexer;
import cy.jdkdigital.productivebees.common.block.HeatedCentrifuge;
import cy.jdkdigital.productivebees.common.block.HoneyFluidBlock;
import cy.jdkdigital.productivebees.common.block.HoneyGenerator;
import cy.jdkdigital.productivebees.common.block.InactiveDragonEgg;
import cy.jdkdigital.productivebees.common.block.Incubator;
import cy.jdkdigital.productivebees.common.block.InvisibleRedstone;
import cy.jdkdigital.productivebees.common.block.Jar;
import cy.jdkdigital.productivebees.common.block.NetherBeeNest;
import cy.jdkdigital.productivebees.common.block.PoweredCentrifuge;
import cy.jdkdigital.productivebees.common.block.SolitaryNest;
import cy.jdkdigital.productivebees.common.block.SugarbagNest;
import cy.jdkdigital.productivebees.common.block.TranslucentCombBlock;
import cy.jdkdigital.productivebees.common.block.WaxBlock;
import cy.jdkdigital.productivebees.common.block.nest.BumbleBeeNest;
import cy.jdkdigital.productivebees.common.block.nest.SugarCaneNest;
import cy.jdkdigital.productivebees.common.block.nest.WoodNest;
import cy.jdkdigital.productivebees.common.item.AmberItem;
import cy.jdkdigital.productivebees.common.item.CombBlockItem;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import cy.jdkdigital.productivebees.init.ModFluids;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.setup.HiveType;
import cy.jdkdigital.productivebees.util.FakeIngredient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.registries.DeferredHolder;

public final class ModBlocks {
    public static final DeferredHolder<Block, ? extends Block> BOTTLER = ModBlocks.createBlock("bottler", () -> new Bottler(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAULDRON)));
    public static final DeferredHolder<Block, ? extends Block> CENTRIFUGE = ModBlocks.createBlock("centrifuge", () -> new Centrifuge(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAULDRON)));
    public static final DeferredHolder<Block, ? extends Block> POWERED_CENTRIFUGE = ModBlocks.createBlock("powered_centrifuge", () -> new PoweredCentrifuge(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAULDRON)));
    public static final DeferredHolder<Block, ? extends Block> HEATED_CENTRIFUGE = ModBlocks.createBlock("heated_centrifuge", () -> new HeatedCentrifuge(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAULDRON)));
    public static final DeferredHolder<Block, ? extends Block> HONEY_GENERATOR = ModBlocks.createBlock("honey_generator", () -> new HoneyGenerator(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAULDRON)));
    public static final DeferredHolder<Block, ? extends Block> CATCHER = ModBlocks.createBlock("catcher", () -> new Catcher(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAULDRON)));
    public static final DeferredHolder<Block, ? extends Block> INCUBATOR = ModBlocks.createBlock("incubator", () -> new Incubator(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAULDRON)));
    public static final DeferredHolder<Block, ? extends Block> INACTIVE_DRAGON_EGG = ModBlocks.createBlock("inactive_dragon_egg", () -> new InactiveDragonEgg(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DRAGON_EGG)));
    public static final DeferredHolder<Block, ? extends Block> INVISIBLE_REDSTONE_BLOCK = ModBlocks.createBlock("invisible_redstone_block", () -> new InvisibleRedstone(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.REDSTONE_BLOCK).noOcclusion().noCollission()));
    public static final DeferredHolder<Block, ? extends Block> FEEDER = ModBlocks.createBlock("feeder", () -> new Feeder(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_SLAB).noOcclusion()));
    public static final DeferredHolder<Block, ? extends Block> JAR = ModBlocks.createBlock("jar_oak", () -> new Jar(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS)));
    public static final DeferredHolder<Block, ? extends Block> QUARTZ_NETHERRACK = ModBlocks.createBlock("quartz_netherrack", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.NETHER_QUARTZ_ORE)));
    public static final DeferredHolder<Block, ? extends Block> WAX_BLOCK = ModBlocks.createBlock("wax_block", () -> new WaxBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.HONEYCOMB_BLOCK)));
    public static final DeferredHolder<Block, ? extends Block> GENE_INDEXER = ModBlocks.createBlock("gene_indexer", () -> new GeneIndexer(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAULDRON)));
    public static final DeferredHolder<Block, ? extends Block> BREEDING_CHAMBER = ModBlocks.createBlock("breeding_chamber", () -> new BreedingChamber(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAULDRON)));
    public static final DeferredHolder<Block, ? extends Block> CRYO_STASIS = ModBlocks.createBlock("cryo_stasis", () -> new CryoStasis(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAULDRON)), false);
    public static final DeferredHolder<Block, ? extends Block> OAK_WOOD_NEST = ModBlocks.createBlock("oak_wood_nest", () -> new WoodNest("#382b18", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LOG)));
    public static final DeferredHolder<Block, ? extends Block> SPRUCE_WOOD_NEST = ModBlocks.createBlock("spruce_wood_nest", () -> new WoodNest("#2e1608", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SPRUCE_LOG)));
    public static final DeferredHolder<Block, ? extends Block> DARK_OAK_WOOD_NEST = ModBlocks.createBlock("dark_oak_wood_nest", () -> new WoodNest("#292011", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DARK_OAK_LOG)));
    public static final DeferredHolder<Block, ? extends Block> BIRCH_WOOD_NEST = ModBlocks.createBlock("birch_wood_nest", () -> new WoodNest("#36342a", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BIRCH_LOG)));
    public static final DeferredHolder<Block, ? extends Block> JUNGLE_WOOD_NEST = ModBlocks.createBlock("jungle_wood_nest", () -> new WoodNest("#3e3013", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.JUNGLE_LOG)));
    public static final DeferredHolder<Block, ? extends Block> ACACIA_WOOD_NEST = ModBlocks.createBlock("acacia_wood_nest", () -> new WoodNest("#504b40", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ACACIA_LOG)));
    public static final DeferredHolder<Block, ? extends Block> CHERRY_WOOD_NEST = ModBlocks.createBlock("cherry_wood_nest", () -> new WoodNest("#271620", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHERRY_LOG)));
    public static final DeferredHolder<Block, ? extends Block> MANGROVE_WOOD_NEST = ModBlocks.createBlock("mangrove_wood_nest", () -> new WoodNest("#443522", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MANGROVE_LOG)));
    public static final DeferredHolder<Block, ? extends Block> BAMBOO_HIVE = ModBlocks.createBlock("bamboo_hive", () -> new BambooHive(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BAMBOO_BLOCK)));
    public static final DeferredHolder<Block, ? extends Block> DRAGON_EGG_HIVE = ModBlocks.createBlock("dragon_egg_hive", () -> new DragonEggHive(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DRAGON_EGG)));
    public static final DeferredHolder<Block, ? extends Block> STONE_NEST = ModBlocks.createBlock("stone_nest", () -> new SolitaryNest(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE)));
    public static final DeferredHolder<Block, ? extends Block> COARSE_DIRT_NEST = ModBlocks.createBlock("coarse_dirt_nest", () -> new SolitaryNest(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COARSE_DIRT)));
    public static final DeferredHolder<Block, ? extends Block> SAND_NEST = ModBlocks.createBlock("sand_nest", () -> new SolitaryNest(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SAND)));
    public static final DeferredHolder<Block, ? extends Block> SNOW_NEST = ModBlocks.createBlock("snow_nest", () -> new SolitaryNest(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SNOW_BLOCK).strength(0.2f)));
    public static final DeferredHolder<Block, ? extends Block> GRAVEL_NEST = ModBlocks.createBlock("gravel_nest", () -> new SolitaryNest(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GRAVEL)));
    public static final DeferredHolder<Block, ? extends Block> SUGAR_CANE_NEST = ModBlocks.createBlock("sugar_cane_nest", () -> new SugarCaneNest(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SUGAR_CANE)));
    public static final DeferredHolder<Block, ? extends Block> SLIMY_NEST = ModBlocks.createBlock("slimy_nest", () -> new SolitaryNest(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SLIME_BLOCK)));
    public static final DeferredHolder<Block, ? extends Block> GLOWSTONE_NEST = ModBlocks.createBlock("glowstone_nest", () -> new SolitaryNest(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLOWSTONE)));
    public static final DeferredHolder<Block, ? extends Block> SOUL_SAND_NEST = ModBlocks.createBlock("soul_sand_nest", () -> new SolitaryNest(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SOUL_SAND)));
    public static final DeferredHolder<Block, ? extends Block> NETHER_QUARTZ_NEST = ModBlocks.createBlock("nether_quartz_nest", () -> new SolitaryNest(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.NETHER_QUARTZ_ORE)));
    public static final DeferredHolder<Block, ? extends Block> NETHER_GOLD_NEST = ModBlocks.createBlock("nether_gold_nest", () -> new SolitaryNest(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.NETHER_GOLD_ORE)));
    public static final DeferredHolder<Block, ? extends Block> NETHER_BRICK_NEST = ModBlocks.createBlock("nether_brick_nest", () -> new SolitaryNest(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.NETHER_BRICKS)));
    public static final DeferredHolder<Block, ? extends Block> END_NEST = ModBlocks.createBlock("end_stone_nest", () -> new SolitaryNest(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.END_STONE)));
    public static final DeferredHolder<Block, ? extends Block> OBSIDIAN_PILLAR_NEST = ModBlocks.createBlock("obsidian_nest", () -> new SolitaryNest(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OBSIDIAN)));
    public static final DeferredHolder<Block, LiquidBlock> HONEY = ModBlocks.createBlock("honey", () -> new HoneyFluidBlock((Supplier<? extends BaseFlowingFluid>)ModFluids.HONEY, BlockBehaviour.Properties.of().noCollission().strength(100.0f).noLootTable().mapColor(MapColor.TERRACOTTA_ORANGE).noCollission().replaceable().liquid().noLootTable().speedFactor(0.3f).jumpFactor(0.3f).friction(1.0f)), false);
    public static final DeferredHolder<Block, ? extends Block> CONFIGURABLE_COMB = ModBlocks.createBlock("configurable_comb", () -> new ConfigurableCombBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.HONEYCOMB_BLOCK), "#c8df24"));
    public static final DeferredHolder<Block, ? extends Block> COMB_GHOSTLY = ModBlocks.createBlock("comb_ghostly", () -> new TranslucentCombBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.HONEYCOMB_BLOCK).noCollission()));
    public static final DeferredHolder<Block, ? extends Block> COMB_MILKY = ModBlocks.createBlock("comb_milky", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.HONEYCOMB_BLOCK)));
    public static final DeferredHolder<Block, ? extends Block> COMB_POWDERY = ModBlocks.createBlock("comb_powdery", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.HONEYCOMB_BLOCK)));
    public static final DeferredHolder<Block, ? extends Block> BUMBLE_BEE_NEST = ModBlocks.createBlock("bumble_bee_nest", () -> new BumbleBeeNest(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GRASS_BLOCK)));
    public static final DeferredHolder<Block, ? extends Block> SUGARBAG_NEST = ModBlocks.createBlock("sugarbag_nest", () -> new SugarbagNest(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BEE_NEST)));
    public static final DeferredHolder<Block, ? extends Block> WARPED_BEE_NEST = ModBlocks.createBlock("warped_bee_nest", () -> new NetherBeeNest(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BEE_NEST)));
    public static final DeferredHolder<Block, ? extends Block> CRIMSON_BEE_NEST = ModBlocks.createBlock("crimson_bee_nest", () -> new NetherBeeNest(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BEE_NEST)));
    public static final DeferredHolder<Block, ? extends Block> AMBER = ModBlocks.createBlock("amber", () -> new Amber(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ORANGE_STAINED_GLASS)));
    public static final DeferredHolder<Block, ? extends Block> PETRIFIED_HONEY = ModBlocks.createBlock("petrified_honey", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_ORANGE).strength(0.3f).noOcclusion().sound(SoundType.BONE_BLOCK)));
    public static final List<DeferredHolder<Block, Block>> PETRIFIED_HONEY_BLOCKS = Arrays.stream(DyeColor.values()).map(dyeColor -> ModBlocks.createBlock(dyeColor.getSerializedName() + "_petrified_honey", () -> new Block(BlockBehaviour.Properties.of().mapColor(dyeColor.getMapColor()).strength(0.3f).noOcclusion().sound(SoundType.BONE_BLOCK)))).toList();
    public static final Map<String, DeferredHolder<Block, ? extends Block>> HIVES = new HashMap<String, DeferredHolder<Block, ? extends Block>>();
    public static final Map<String, DeferredHolder<Block, ? extends Block>> EXPANSIONS = new HashMap<String, DeferredHolder<Block, ? extends Block>>();
    public static final Map<String, DeferredHolder<Block, ? extends Block>> CANVAS_HIVES = new HashMap<String, DeferredHolder<Block, ? extends Block>>();
    public static final Map<String, DeferredHolder<Block, ? extends Block>> CANVAS_EXPANSIONS = new HashMap<String, DeferredHolder<Block, ? extends Block>>();
    public static final Map<String, Map<String, HiveType>> HIVELIST = new HashMap<String, Map<String, HiveType>>(){
        {
            this.put("productivebees", new HashMap<String, HiveType>(){
                {
                    this.put("oak", new HiveType(false, "#c29d62", "oak", (ItemLike)Blocks.OAK_PLANKS, null));
                    this.put("spruce", new HiveType(false, "#886539", "spruce", (ItemLike)Blocks.SPRUCE_PLANKS, null));
                    this.put("birch", new HiveType(false, "#d7cb8d", "birch", (ItemLike)Blocks.BIRCH_PLANKS, null));
                    this.put("jungle", new HiveType(false, "#b88764", "jungle", (ItemLike)Blocks.JUNGLE_PLANKS, null));
                    this.put("acacia", new HiveType(false, "#c26d3f", "acacia", (ItemLike)Blocks.ACACIA_PLANKS, null));
                    this.put("dark_oak", new HiveType(false, "#53381a", "dark_oak", (ItemLike)Blocks.DARK_OAK_PLANKS, null));
                    this.put("crimson", new HiveType(false, "#924160", "crimson", (ItemLike)Blocks.CRIMSON_PLANKS, null));
                    this.put("warped", new HiveType(false, "#279994", "warped", (ItemLike)Blocks.WARPED_PLANKS, null));
                    this.put("mangrove", new HiveType(false, "#773934", "mangrove", (ItemLike)Blocks.MANGROVE_PLANKS, null));
                    this.put("cherry", new HiveType(false, "#e6b3ad", "cherry", (ItemLike)Blocks.CHERRY_PLANKS, null));
                    this.put("bamboo", new HiveType(false, "#e3cc6a", "bamboo", (ItemLike)Blocks.BAMBOO_PLANKS, null));
                    this.put("snake_block", new HiveType(false, "#477566", "snake_block", (ItemLike)Items.PRISMARINE_SHARD, null));
                }
            });
            this.put("atmospheric", new HashMap<String, HiveType>(){
                {
                    this.put("aspen", new HiveType(false, "#f7cf4c", "aspen", null, new FakeIngredient("atmospheric:aspen_planks")));
                    this.put("grimwood", new HiveType(false, "#382721", "grimwood", null, new FakeIngredient("atmospheric:grimwood_planks")));
                    this.put("kousa", new HiveType(false, "#84a083", "kousa", null, new FakeIngredient("atmospheric:kousa_planks")));
                    this.put("morado", new HiveType(false, "#a64443", "mangrove", null, new FakeIngredient("atmospheric:morado_planks")));
                    this.put("yucca", new HiveType(false, "#c17d6a", "yucca", null, new FakeIngredient("atmospheric:yucca_planks")));
                    this.put("rosewood", new HiveType(false, "#956f7b", "rosewood", null, new FakeIngredient("atmospheric:rosewood_planks")));
                }
            });
            this.put("upgrade_aquatic", new HashMap<String, HiveType>(){
                {
                    this.put("driftwood", new HiveType(false, "#82746b", "driftwood", null, new FakeIngredient("upgrade_aquatic:driftwood_planks")));
                    this.put("river", new HiveType(false, "#8c6646", "river", null, new FakeIngredient("upgrade_aquatic:river_planks")));
                }
            });
            this.put("autumnity", new HashMap<String, HiveType>(){
                {
                    this.put("maple", new HiveType(false, "#aa6e3d", "maple", null, new FakeIngredient("autumnity:maple_planks")));
                }
            });
            this.put("endergetic", new HashMap<String, HiveType>(){
                {
                    this.put("poise", new HiveType(false, "#8f4b90", "oak", null, new FakeIngredient("endergetic:poise_planks")));
                }
            });
            this.put("environmental", new HashMap<String, HiveType>(){
                {
                    this.put("wisteria", new HiveType(false, "#ebe8cc", "wisteria", null, new FakeIngredient("environmental:wisteria_planks")));
                }
            });
            this.put("quark", new HashMap<String, HiveType>(){
                {
                    this.put("azalea", new HiveType(false, "#c1d368", "dark_oak", null, new FakeIngredient("quark:azalea_planks")));
                    this.put("blossom", new HiveType(false, "#6b3324", "rosewood", null, new FakeIngredient("quark:blossom_planks")));
                }
            });
            this.put("byg", new HashMap<String, HiveType>(){
                {
                    this.put("aspen", new HiveType(false, "#efcd7c", "aspen", null, new FakeIngredient("byg:aspen_planks")));
                    this.put("baobab", new HiveType(false, "#b3995b", "acacia", null, new FakeIngredient("byg:baobab_planks")));
                    this.put("blue_enchanted", new HiveType(false, "#6574bb", "magic", null, new FakeIngredient("byg:blue_enchanted_planks")));
                    this.put("bulbis", new HiveType(false, "#893fb4", "warped", null, new FakeIngredient("byg:bulbis_planks")));
                    this.put("cika", new HiveType(false, "#a65642", "driftwood", null, new FakeIngredient("byg:cika_planks")));
                    this.put("cypress", new HiveType(false, "#aca272", "yucca", null, new FakeIngredient("byg:cypress_planks")));
                    this.put("ebony", new HiveType(false, "#343232", "rosewood", null, new FakeIngredient("byg:ebony_planks")));
                    this.put("embur", new HiveType(false, "#5d4b3c", "bamboo", null, new FakeIngredient("byg:embur_planks")));
                    this.put("ether", new HiveType(false, "#0d79ab", "cherry", null, new FakeIngredient("byg:ether_planks")));
                    this.put("fir", new HiveType(false, "#b28f6c", "fir", null, new FakeIngredient("byg:fir_planks")));
                    this.put("green_enchanted", new HiveType(false, "#54a564", "magic", null, new FakeIngredient("byg:green_enchanted_planks")));
                    this.put("holly", new HiveType(false, "#ddb4a2", "crimson", null, new FakeIngredient("byg:holly_planks")));
                    this.put("imparius", new HiveType(false, "#77b1b5", "dead", null, new FakeIngredient("byg:imparius_planks")));
                    this.put("jacaranda", new HiveType(false, "#c19b9d", "jacaranda", null, new FakeIngredient("byg:jacaranda_planks")));
                    this.put("lament", new HiveType(false, "#574fa1", "jungle", null, new FakeIngredient("byg:lament_planks")));
                    this.put("mahogany", new HiveType(false, "#9e6a88", "mahogany", null, new FakeIngredient("byg:mahogany_planks")));
                    this.put("maple", new HiveType(false, "#978d83", "wisteria", null, new FakeIngredient("byg:maple_planks")));
                    this.put("nightshade", new HiveType(false, "#d6781c", "umbran", null, new FakeIngredient("byg:nightshade_planks")));
                    this.put("palm", new HiveType(false, "#a89b7a", "palm", null, new FakeIngredient("byg:palm_planks")));
                    this.put("pine", new HiveType(false, "#c5b99a", "dark_oak", null, new FakeIngredient("byg:pine_planks")));
                    this.put("redwood", new HiveType(false, "#9c4141", "redwood", null, new FakeIngredient("byg:redwood_planks")));
                    this.put("skyris", new HiveType(false, "#95bccb", "kousa", null, new FakeIngredient("byg:skyris_planks")));
                    this.put("sythian", new HiveType(false, "#ccb251", "oak", null, new FakeIngredient("byg:sythian_planks")));
                    this.put("white_mangrove", new HiveType(false, "#d1d1d1", "mangrove", null, new FakeIngredient("byg:white_mangrove_planks")));
                    this.put("willow", new HiveType(false, "#55662d", "willow", null, new FakeIngredient("byg:willow_planks")));
                    this.put("witch_hazel", new HiveType(false, "#3b8c5b", "hellbark", null, new FakeIngredient("byg:witch_hazel_planks")));
                    this.put("zelkova", new HiveType(false, "#bf6d36", "birch", null, new FakeIngredient("byg:zelkova_planks")));
                }
            });
            this.put("biomesoplenty", new HashMap<String, HiveType>(){
                {
                    this.put("fir", new HiveType(false, "#b3a78c", "fir", null, new FakeIngredient("biomesoplenty:fir_planks")));
                    this.put("redwood", new HiveType(false, "#a5553a", "redwood", null, new FakeIngredient("biomesoplenty:redwood_planks")));
                    this.put("mahogany", new HiveType(false, "#cf8987", "mahogany", null, new FakeIngredient("biomesoplenty:mahogany_planks")));
                    this.put("jacaranda", new HiveType(false, "#dbbfb5", "jacaranda", null, new FakeIngredient("biomesoplenty:jacaranda_planks")));
                    this.put("palm", new HiveType(false, "#d19445", "palm", null, new FakeIngredient("biomesoplenty:palm_planks")));
                    this.put("willow", new HiveType(false, "#a2b084", "willow", null, new FakeIngredient("biomesoplenty:willow_planks")));
                    this.put("dead", new HiveType(false, "#958e85", "dead", null, new FakeIngredient("biomesoplenty:dead_planks")));
                    this.put("magic", new HiveType(false, "#537abf", "magic", null, new FakeIngredient("biomesoplenty:magic_planks")));
                    this.put("umbran", new HiveType(false, "#7d6a8f", "umbran", null, new FakeIngredient("biomesoplenty:umbran_planks")));
                    this.put("hellbark", new HiveType(false, "#3b3031", "hellbark", null, new FakeIngredient("biomesoplenty:hellbark_planks")));
                }
            });
            this.put("regions_unexplored", new HashMap<String, HiveType>(){
                {
                    this.put("baobab", new HiveType(false, "#f8cfb4", "redwood", null, new FakeIngredient("regions_unexplored:baobab_planks")));
                    this.put("blackwood", new HiveType(false, "#3d332c", "spruce", null, new FakeIngredient("regions_unexplored:blackwood_planks")));
                    this.put("blue_bioshroom", new HiveType(false, "#82d9e7", "mahogany", null, new FakeIngredient("regions_unexplored:blue_bioshroom_planks")));
                    this.put("cobalt", new HiveType(false, "#19317a", "jacaranda", null, new FakeIngredient("regions_unexplored:cobalt_planks")));
                    this.put("cypress", new HiveType(false, "#929062", "yucca", null, new FakeIngredient("regions_unexplored:cypress_planks")));
                    this.put("dead", new HiveType(false, "#786b66", "dead", null, new FakeIngredient("regions_unexplored:dead_planks")));
                    this.put("eucalyptus", new HiveType(false, "#c38362", "willow", null, new FakeIngredient("regions_unexplored:eucalyptus_planks")));
                    this.put("green_bioshroom", new HiveType(false, "#9ee487", "mahogany", null, new FakeIngredient("regions_unexplored:green_bioshroom_planks")));
                    this.put("joshua", new HiveType(false, "#c0a183", "kousa", null, new FakeIngredient("regions_unexplored:joshua_planks")));
                    this.put("kapok", new HiveType(false, "#b98c7b", "dark_oak", null, new FakeIngredient("regions_unexplored:kapok_planks")));
                    this.put("larch", new HiveType(false, "#b98c7b", "mangrove", null, new FakeIngredient("regions_unexplored:larch_planks")));
                    this.put("maple", new HiveType(false, "#c7a45e", "maple", null, new FakeIngredient("regions_unexplored:maple_planks")));
                    this.put("palm", new HiveType(false, "#e5d09d", "palm", null, new FakeIngredient("regions_unexplored:palm_planks")));
                    this.put("redwood", new HiveType(false, "#b75d45", "redwood", null, new FakeIngredient("regions_unexplored:redwood_planks")));
                    this.put("socotra", new HiveType(false, "#b4915c", "magic", null, new FakeIngredient("regions_unexplored:socotra_planks")));
                    this.put("magnolia", new HiveType(false, "#b74648", "umbran", null, new FakeIngredient("regions_unexplored:magnolia_planks")));
                    this.put("mauve", new HiveType(false, "#8e6e97", "hellbark", null, new FakeIngredient("regions_unexplored:mauve_planks")));
                    this.put("pine", new HiveType(false, "#dabb8f", "river", null, new FakeIngredient("regions_unexplored:pine_planks")));
                    this.put("willow", new HiveType(false, "#c5bda6", "willow", null, new FakeIngredient("regions_unexplored:willow_planks")));
                    this.put("pink_bioshroom", new HiveType(false, "#dd8dd9", "mahogany", null, new FakeIngredient("regions_unexplored:pink_bioshroom_planks")));
                    this.put("yellow_bioshroom", new HiveType(false, "#e2cd89", "mahogany", null, new FakeIngredient("regions_unexplored:yellow_bioshroom_planks")));
                }
            });
        }
    };
    public static List<String> hiveStyles = new ArrayList<String>(){
        {
            this.add("acacia");
            this.add("aspen");
            this.add("bamboo");
            this.add("birch");
            this.add("cherry");
            this.add("concrete");
            this.add("comb");
            this.add("crimson");
            this.add("dark_oak");
            this.add("dead");
            this.add("driftwood");
            this.add("fir");
            this.add("grimwood");
            this.add("hellbark");
            this.add("jacaranda");
            this.add("jungle");
            this.add("kousa");
            this.add("magic");
            this.add("mahogany");
            this.add("mangrove");
            this.add("maple");
            this.add("oak");
            this.add("palm");
            this.add("redwood");
            this.add("river");
            this.add("rosewood");
            this.add("snake_block");
            this.add("spruce");
            this.add("umbran");
            this.add("warped");
            this.add("willow");
            this.add("wisteria");
            this.add("yucca");
        }
    };

    public static void registerHives() {
        HIVELIST.forEach((modid, strings) -> {
            if (ProductiveBees.includeMod(modid)) {
                strings.forEach((name, type) -> {
                    name = modid.equals("productivebees") ? name : modid + "_" + name;
                    String hiveName = "advanced_" + name + "_beehive";
                    String boxName = "expansion_box_" + name;
                    if (!HIVES.containsKey(hiveName)) {
                        BlockBehaviour.Properties properties;
                        ItemLike patt0$temp = type.planks();
                        if (patt0$temp instanceof Block) {
                            Block plankBlock = (Block)patt0$temp;
                            properties = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)plankBlock).instrument(NoteBlockInstrument.BASS).strength(0.6f);
                        } else {
                            properties = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BEEHIVE);
                        }
                        BlockBehaviour.Properties properties2 = properties;
                        HIVES.put(hiveName, ModBlocks.createBlock(hiveName, () -> new AdvancedBeehive(properties2), true));
                        EXPANSIONS.put(boxName, ModBlocks.createBlock(boxName, () -> new ExpansionBox(properties2), true));
                    }
                });
            }
        });
        hiveStyles.forEach(style -> {
            String canvasHiveName = "advanced_" + style + "_canvas_beehive";
            DeferredHolder<Block, CanvasBeehive> hiveBlock = ModBlocks.createBlock(canvasHiveName, () -> new CanvasBeehive(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BEEHIVE)), true);
            HIVES.put(canvasHiveName, hiveBlock);
            CANVAS_HIVES.put(canvasHiveName, hiveBlock);
            String canvasBoxName = "expansion_box_" + style + "_canvas";
            DeferredHolder<Block, CanvasExpansionBox> boxBlock = ModBlocks.createBlock(canvasBoxName, () -> new CanvasExpansionBox(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BEEHIVE)), true);
            EXPANSIONS.put(canvasBoxName, boxBlock);
            CANVAS_EXPANSIONS.put(canvasBoxName, boxBlock);
        });
        ModBlockEntityTypes.registerHiveBlockEntities();
    }

    public static <E extends BlockEntity> BlockEntityType<E> createBlockEntityType(BlockEntityType.BlockEntitySupplier<E> factory, Block ... blocks) {
        return BlockEntityType.Builder.of(factory, (Block[])blocks).build(null);
    }

    public static <B extends Block> DeferredHolder<Block, B> createBlock(String name, Supplier<? extends B> supplier) {
        return ModBlocks.createBlock(name, supplier, true);
    }

    public static <B extends Block> DeferredHolder<Block, B> createBlock(String name, Supplier<? extends B> supplier, boolean createItem) {
        DeferredHolder block = ProductiveBees.BLOCKS.register(name, supplier);
        if (createItem) {
            Item.Properties properties = new Item.Properties();
            if (name.equals("configurable_comb")) {
                ModItems.CONFIGURABLE_COMB_BLOCK = ProductiveBees.ITEMS.register(name, () -> new CombBlockItem((Block)block.get(), properties));
            } else if (name.equals("jar_oak")) {
                ProductiveBees.ITEMS.register(name, () -> new BlockItem((Block)block.get(), properties));
            } else if (name.equals("amber")) {
                ProductiveBees.ITEMS.register(name, () -> new AmberItem((Block)block.get(), properties));
            } else {
                if (name.equals("comb_netherite")) {
                    properties.fireResistant();
                }
                ProductiveBees.ITEMS.register(name, () -> new BlockItem((Block)block.get(), properties));
            }
        }
        return block;
    }
}

