/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container.gui;

import cy.jdkdigital.productivebees.common.block.entity.CentrifugeBlockEntity;
import cy.jdkdigital.productivebees.common.block.entity.PoweredCentrifugeBlockEntity;
import cy.jdkdigital.productivebees.container.CentrifugeContainer;
import cy.jdkdigital.productivebees.util.FluidContainerUtil;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.fluids.FluidStack;

public class CentrifugeScreen
extends AbstractContainerScreen<CentrifugeContainer> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/gui/container/centrifuge.png");
    private static final ResourceLocation GUI_TEXTURE_POWERED = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/gui/container/powered_centrifuge.png");
    private static final ResourceLocation GUI_TEXTURE_HEATED = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/gui/container/heated_centrifuge.png");

    public CentrifugeScreen(CentrifugeContainer container, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)container, inv, titleIn);
    }

    public void render(@Nonnull GuiGraphics matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.render(matrixStack, mouseX, mouseY, partialTicks);
        this.renderTooltip(matrixStack, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        CentrifugeBlockEntity centrifugeBlockEntity;
        guiGraphics.drawString(this.font, this.title, -5, 6, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, -5, this.getYSize() - 96 + 2, 0x404040, false);
        FluidStack fluidStack = ((CentrifugeContainer)this.menu).blockEntity.fluidHandler.getFluidInTank(0);
        if (this.isHovering(129, 16, 6, 54, mouseX, mouseY)) {
            ArrayList<FormattedCharSequence> tooltipList = new ArrayList<FormattedCharSequence>();
            if (fluidStack.getAmount() > 0) {
                tooltipList.add(Component.translatable((String)"productivebees.screen.fluid_level", (Object[])new Object[]{fluidStack.getHoverName().getString(), fluidStack.getAmount() + "mB"}).getVisualOrderText());
            } else {
                tooltipList.add(Component.translatable((String)"productivebees.hive.tooltip.empty").getVisualOrderText());
            }
            guiGraphics.renderTooltip(this.font, tooltipList, mouseX - this.getGuiLeft(), mouseY - this.getGuiTop());
        }
        if ((centrifugeBlockEntity = ((CentrifugeContainer)this.menu).blockEntity) instanceof PoweredCentrifugeBlockEntity) {
            PoweredCentrifugeBlockEntity poweredCentrifugeBlockEntity = (PoweredCentrifugeBlockEntity)centrifugeBlockEntity;
            int energyAmount = poweredCentrifugeBlockEntity.energyHandler.getEnergyStored();
            if (this.isHovering(-5, 16, 6, 54, mouseX, mouseY)) {
                ArrayList<FormattedCharSequence> tooltipList = new ArrayList<FormattedCharSequence>();
                tooltipList.add(Component.translatable((String)"productivebees.screen.energy_level", (Object[])new Object[]{energyAmount + "FE"}).getVisualOrderText());
                guiGraphics.renderTooltip(this.font, tooltipList, mouseX - this.getGuiLeft(), mouseY - this.getGuiTop());
            }
        }
    }

    protected void renderBg(@Nonnull GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        FluidStack fluidStack;
        CentrifugeBlockEntity progress2;
        ResourceLocation GUI = ((CentrifugeContainer)this.menu).blockEntity instanceof PoweredCentrifugeBlockEntity ? GUI_TEXTURE_POWERED : GUI_TEXTURE;
        guiGraphics.blit(GUI, this.getGuiLeft() - 13, this.getGuiTop(), 0, 0, this.getXSize() + 26, this.getYSize());
        if (((CentrifugeContainer)this.menu).blockEntity.recipeProgress > 0) {
            int processingTime = ((CentrifugeContainer)this.menu).blockEntity.getProcessingTime(((CentrifugeContainer)this.menu).blockEntity.getCurrentRecipe());
            int progress2 = (int)((float)(processingTime - ((CentrifugeContainer)this.menu).blockEntity.recipeProgress) * (24.0f / (float)processingTime));
            guiGraphics.blit(GUI, this.getGuiLeft() + 35, this.getGuiTop() + 35, 202, 52, progress2 + 1, 16);
        }
        if ((progress2 = ((CentrifugeContainer)this.menu).blockEntity) instanceof PoweredCentrifugeBlockEntity) {
            PoweredCentrifugeBlockEntity poweredCentrifugeBlockEntity = (PoweredCentrifugeBlockEntity)progress2;
            guiGraphics.blit(GUI, this.getGuiLeft() - 5, this.getGuiTop() + 17, 206, 0, 4, 52);
            int energyAmount = poweredCentrifugeBlockEntity.energyHandler.getEnergyStored();
            int energyLevel = (int)((float)energyAmount * 0.0052f);
            guiGraphics.blit(GUI, this.getGuiLeft() - 5, this.getGuiTop() + 17, 8, 17, 4, 52 - energyLevel);
        }
        if ((fluidStack = ((CentrifugeContainer)this.menu).blockEntity.fluidHandler.getFluidInTank(0)).getAmount() > 0) {
            FluidContainerUtil.renderFluidTank(guiGraphics, this, fluidStack, ((CentrifugeContainer)this.menu).blockEntity.fluidHandler.getTankCapacity(0), 127, 17, 4, 52, 0);
        }
    }
}

