/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.item;

import com.mojang.datafixers.util.Pair;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.AdvancedBeehive;
import cy.jdkdigital.productivebees.common.block.SolitaryNest;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModDataComponents;
import cy.jdkdigital.productivebees.init.ModPointOfInterestTypes;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class NestLocator
extends Item {
    public NestLocator(Item.Properties properties) {
        super(properties);
    }

    public static String getNestName(ItemStack stack) {
        if (!NestLocator.hasNest(stack)) {
            return Blocks.BEE_NEST.getName().getString();
        }
        Block nestBlock = NestLocator.getNestBlock(stack);
        return nestBlock != null ? nestBlock.getName().getString() : "";
    }

    public static ResourceLocation getNestRegistryName(ItemStack stack) {
        return (ResourceLocation)stack.get(ModDataComponents.NEST_BLOCK);
    }

    public static Block getNestBlock(ItemStack stack) {
        ResourceLocation registryName = NestLocator.getNestRegistryName(stack);
        if (registryName != null) {
            return (Block)BuiltInRegistries.BLOCK.get(registryName);
        }
        return null;
    }

    public static void setNestBlock(ItemStack stack, @Nullable Block nest, Player player) {
        if (nest != null) {
            stack.set(ModDataComponents.NEST_BLOCK, (Object)BuiltInRegistries.BLOCK.getKey((Object)nest));
            player.displayClientMessage((Component)Component.translatable((String)"productivebees.nest_locator.tuned", (Object[])new Object[]{nest.getName().getString()}), false);
        }
    }

    public static boolean hasNest(ItemStack stack) {
        return NestLocator.getNestRegistryName(stack) != null;
    }

    public static BlockPos getPosition(ItemStack stack) {
        return NestLocator.hasPosition(stack) ? (BlockPos)stack.get(ModDataComponents.POSITION) : null;
    }

    public static void setPosition(ItemStack stack, @Nullable BlockPos pos) {
        if (pos != null) {
            stack.set(ModDataComponents.POSITION, (Object)pos);
        } else {
            stack.remove(ModDataComponents.POSITION);
        }
    }

    public static boolean hasPosition(ItemStack stack) {
        return stack.has(ModDataComponents.POSITION);
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        if (!world.isClientSide && context.getPlayer() != null && context.getPlayer().isShiftKeyDown()) {
            ItemStack stack = context.getPlayer().getItemInHand(context.getHand());
            BlockState state = world.getBlockState(context.getClickedPos());
            Block block = state.getBlock();
            if (block instanceof BeehiveBlock || block instanceof AdvancedBeehive) {
                NestLocator.setNestBlock(stack, Blocks.BEE_NEST, context.getPlayer());
            } else if (block instanceof SolitaryNest) {
                NestLocator.setNestBlock(stack, block, context.getPlayer());
            } else if (BuiltInRegistries.BLOCK.getKey((Object)block).getPath().contains("warped")) {
                NestLocator.setNestBlock(stack, (Block)ModBlocks.WARPED_BEE_NEST.get(), context.getPlayer());
            } else if (BuiltInRegistries.BLOCK.getKey((Object)block).getPath().contains("crimson")) {
                NestLocator.setNestBlock(stack, (Block)ModBlocks.CRIMSON_BEE_NEST.get(), context.getPlayer());
            } else {
                Block nest = SolitaryNest.BLOCK_TO_NEST.get().get(block);
                if (nest instanceof SolitaryNest) {
                    NestLocator.setNestBlock(stack, nest, context.getPlayer());
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @Nonnull InteractionHand hand) {
        if (!world.isClientSide && world instanceof ServerLevel) {
            ItemStack stack = player.getItemInHand(hand);
            if (!player.isShiftKeyDown()) {
                Pair<Double, BlockPos> nearest;
                Predicate<Block> predicate = o -> o instanceof BeehiveBlock;
                if (NestLocator.hasNest(stack)) {
                    predicate = o -> o.equals(NestLocator.getNestBlock(stack));
                }
                if ((nearest = this.findNearestNest((ServerLevel)world, player.blockPosition(), (Integer)ProductiveBeesConfig.GENERAL.nestLocatorDistance.get(), predicate)) != null) {
                    player.displayClientMessage((Component)Component.translatable((String)"productivebees.nest_locator.found_hive", (Object[])new Object[]{(double)Math.round((Double)nearest.getFirst() * 100.0) / 100.0}), false);
                    NestLocator.setPosition(stack, (BlockPos)nearest.getSecond());
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"productivebees.nest_locator.not_found_hive", (Object[])new Object[]{NestLocator.getNestName(stack)}), false);
                    NestLocator.setPosition(stack, null);
                }
            }
            return InteractionResultHolder.success((Object)player.getItemInHand(hand));
        }
        return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        if (NestLocator.hasNest(pStack)) {
            pTooltipComponents.add((Component)Component.translatable((String)"productivebees.information.nestlocator.configured", (Object[])new Object[]{NestLocator.getNestName(pStack)}).withStyle(ChatFormatting.GOLD));
        } else {
            pTooltipComponents.add((Component)Component.translatable((String)"productivebees.information.nestlocator.unconfigured").withStyle(ChatFormatting.GOLD));
        }
    }

    private Pair<Double, BlockPos> findNearestNest(ServerLevel world, BlockPos pos, int distance, Predicate<Block> predicate) {
        Vec3 playerPos = new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        PoiManager poiManager = world.getPoiManager();
        Stream stream = poiManager.getInSquare(poi -> poi.is(PoiTypeTags.BEE_HOME) || poi.value() == ModPointOfInterestTypes.SOLITARY_HIVE.get() || poi.value() == ModPointOfInterestTypes.SOLITARY_NEST.get() || poi.value() == ModPointOfInterestTypes.DRACONIC_NEST.get() || poi.value() == ModPointOfInterestTypes.BUMBLE_BEE_NEST.get() || poi.value() == ModPointOfInterestTypes.NETHER_NEST.get() || poi.value() == ModPointOfInterestTypes.SUGARBAG_NEST.get(), pos, distance, PoiManager.Occupancy.ANY);
        List nearbyNestPositions = stream.map(PoiRecord::getPos).filter(nestPos -> {
            BlockState state = world.getBlockState(nestPos);
            return predicate.test(state.getBlock());
        }).sorted(Comparator.comparingDouble(vec -> vec.distSqr((Vec3i)pos))).collect(Collectors.toList());
        if (!nearbyNestPositions.isEmpty()) {
            BlockPos nearestPos = (BlockPos)nearbyNestPositions.iterator().next();
            double distanceToNest = playerPos.distanceTo(new Vec3((double)nearestPos.getX(), (double)nearestPos.getY(), (double)nearestPos.getZ()));
            return new Pair((Object)distanceToNest, (Object)nearestPos);
        }
        return null;
    }
}

