/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.item;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.capabilities.attributes.BeeAttributesHandler;
import cy.jdkdigital.productivebees.common.advancements.criterion.CalmBeeTrigger;
import cy.jdkdigital.productivebees.common.item.Gene;
import cy.jdkdigital.productivebees.init.ModAdvancements;
import cy.jdkdigital.productivebees.init.ModDataComponents;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.util.ColorUtil;
import cy.jdkdigital.productivebees.util.GeneAttribute;
import cy.jdkdigital.productivebees.util.GeneGroup;
import cy.jdkdigital.productivebees.util.GeneValue;
import cy.jdkdigital.productivelib.util.LangUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class HoneyTreat
extends Item {
    public HoneyTreat(Item.Properties properties) {
        super(properties);
    }

    public static boolean hasGene(ItemStack itemStack) {
        List geneGroups = (List)itemStack.get(ModDataComponents.GENE_GROUP_LIST);
        return !itemStack.isEmpty() && geneGroups != null && !geneGroups.isEmpty();
    }

    public static ItemStack getTypeStack(String beeType, int value) {
        ItemStack treat = new ItemStack((ItemLike)ModItems.HONEY_TREAT.get());
        HoneyTreat.addGene(treat, Gene.getStack(beeType, value));
        return treat;
    }

    public static void addGene(ItemStack stack, ItemStack geneStack) {
        ArrayList<GeneGroup> geneGroups = new ArrayList<GeneGroup>(HoneyTreat.getGenes(stack));
        GeneGroup addedGeneGroup = Gene.getGene(geneStack);
        if (addedGeneGroup != null) {
            boolean addedToExistingGene = false;
            ListIterator<GeneGroup> iterator = geneGroups.listIterator();
            while (iterator.hasNext()) {
                GeneGroup geneGroup = iterator.next();
                if (!geneGroup.attribute().equals((Object)addedGeneGroup.attribute()) || !geneGroup.value().equals(addedGeneGroup.value())) continue;
                int purity = geneGroup.purity();
                purity = Math.min(100, purity + Gene.getPurity(geneStack));
                iterator.set(GeneGroup.increasePurity(geneGroup, purity));
                addedToExistingGene = true;
            }
            if (!addedToExistingGene) {
                geneGroups.add(addedGeneGroup);
            }
            stack.set(ModDataComponents.GENE_GROUP_LIST, geneGroups);
        }
    }

    public static List<GeneGroup> getGenes(ItemStack stack) {
        List geneGroups = (List)stack.get(ModDataComponents.GENE_GROUP_LIST);
        return geneGroups != null ? geneGroups : new ArrayList();
    }

    public static boolean hasBeeType(ItemStack stack) {
        List<GeneGroup> genes = HoneyTreat.getGenes(stack);
        for (GeneGroup geneGroup : genes) {
            if (!geneGroup.attribute().equals((Object)GeneAttribute.TYPE)) continue;
            return true;
        }
        return false;
    }

    public static void applyGenesToBee(Level level, ItemStack treat, Bee bee) {
        BeeAttributesHandler data = (BeeAttributesHandler)bee.getData(ProductiveBees.ATTRIBUTE_HANDLER);
        List<GeneGroup> geneGroups = HoneyTreat.getGenes(treat);
        for (GeneGroup geneGroup : geneGroups) {
            int purity = geneGroup.purity();
            if (level.random.nextInt(100) > purity) continue;
            data.setAttributeValue(geneGroup.attribute(), GeneValue.byName(geneGroup.value()));
            level.levelEvent(2005, bee.blockPosition(), 0);
        }
        bee.setData(ProductiveBees.ATTRIBUTE_HANDLER, (Object)data);
    }

    public InteractionResult interactLivingEntity(ItemStack itemStack, Player player, LivingEntity target, InteractionHand hand) {
        Bee bee;
        Level level;
        block12: {
            block11: {
                level = target.getCommandSenderWorld();
                if (level.isClientSide() || !(target instanceof Bee)) break block11;
                bee = (Bee)target;
                if (target.isAlive()) break block12;
            }
            return InteractionResult.PASS;
        }
        if (player instanceof ServerPlayer && bee.isAngry()) {
            ((CalmBeeTrigger)((Object)ModAdvancements.CALM_BEE.get())).trigger((ServerPlayer)player, bee);
        }
        bee.setRemainingPersistentAngerTime(0);
        bee.setStayOutOfHiveCountdown(0);
        bee.heal(bee.getMaxHealth());
        if (bee.isBaby()) {
            bee.ageUp((int)((float)(-bee.getAge() / 20) * 0.1f), true);
        }
        BlockPos pos = target.blockPosition();
        level.addParticle((ParticleOptions)ParticleTypes.POOF, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), 0.2, 0.1, 0.2);
        bee.playAmbientSound();
        if (bee.hasData(ProductiveBees.ATTRIBUTE_HANDLER) && !HoneyTreat.hasBeeType(itemStack)) {
            if (HoneyTreat.hasGene(itemStack)) {
                HoneyTreat.applyGenesToBee(level, itemStack, bee);
            } else {
                BeeAttributesHandler data = (BeeAttributesHandler)bee.getData(ProductiveBees.ATTRIBUTE_HANDLER);
                GeneValue temper = data.getAttributeValue(GeneAttribute.TEMPER);
                if (temper.getValue() > 0 && player.level().random.nextFloat() < 0.05f) {
                    data.setAttributeValue(GeneAttribute.TEMPER, GeneValue.nextTemper(temper));
                    bee.setData(ProductiveBees.ATTRIBUTE_HANDLER, (Object)data);
                }
            }
            player.swing(hand);
        } else if (HoneyTreat.hasBeeType(itemStack)) {
            player.sendSystemMessage((Component)Component.translatable((String)"productivebees.honey_treat.invalid_use"));
        }
        itemStack.shrink(1);
        return InteractionResult.CONSUME;
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        List geneGroups = (List)pStack.get(ModDataComponents.GENE_GROUP_LIST);
        if (geneGroups != null) {
            geneGroups.forEach(geneGroup -> {
                if (!geneGroup.attribute().equals((Object)GeneAttribute.TYPE)) {
                    MutableComponent translatedValue = Component.translatable((String)("productivebees.information.attribute." + geneGroup.value())).withStyle(ColorUtil.getAttributeColor(GeneValue.byName(geneGroup.value())));
                    pTooltipComponents.add((Component)Component.translatable((String)("productivebees.information.attribute." + geneGroup.attribute().getSerializedName()), (Object[])new Object[]{translatedValue}).withStyle(ChatFormatting.DARK_GRAY).append(" (" + geneGroup.purity() + "%)"));
                } else {
                    pTooltipComponents.add((Component)Component.translatable((String)"productivebees.information.attribute.type", (Object[])new Object[]{LangUtil.capName((String)ResourceLocation.parse((String)geneGroup.value()).getPath())}).withStyle(ChatFormatting.GOLD).append(" (" + geneGroup.purity() + "%)"));
                }
            });
        }
    }
}

