/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.item;

import cy.jdkdigital.productivebees.init.ModBlocks;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class AmberItem
extends BlockItem {
    public AmberItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public Component getName(ItemStack pStack) {
        if (pStack.has(DataComponents.ENTITY_DATA)) {
            CompoundTag tag = ((CustomData)pStack.get(DataComponents.ENTITY_DATA)).copyTag();
            return Component.translatable((String)"productivebees.amber.name.contained_entity", (Object[])new Object[]{Component.literal((String)tag.getString("name"))});
        }
        return super.getName(pStack);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        pTooltipComponents.add((Component)Component.translatable((String)"productivebees.amber.tooltip.heating").withStyle(ChatFormatting.DARK_RED));
        if (pStack.has(DataComponents.ENTITY_DATA)) {
            CompoundTag tag = ((CustomData)pStack.get(DataComponents.ENTITY_DATA)).copyTag();
            pTooltipComponents.add((Component)Component.translatable((String)"productivebees.amber.tooltip.contained_entity", (Object[])new Object[]{Component.literal((String)tag.getString("name")).withStyle(ChatFormatting.GOLD)}).withStyle(ChatFormatting.WHITE));
        }
    }

    public static ItemStack getFakeAmberItem(EntityType<?> entityType) {
        ItemStack stack = new ItemStack((ItemLike)ModBlocks.AMBER.get());
        CompoundTag entityTag = new CompoundTag();
        entityTag.putString("name", Component.translatable((String)entityType.getDescriptionId()).getString());
        entityTag.putString("id", BuiltInRegistries.ENTITY_TYPE.getKey(entityType).toString());
        stack.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)entityTag));
        return stack;
    }
}

