/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.entity.bee.hive;

import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.util.GeneAttribute;
import cy.jdkdigital.productivebees.util.GeneValue;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CupidBee
extends ProductiveBee {
    public Animal targetEntity = null;
    private int animalsBredSincePollination;
    private SetLoveModeGoal loveGoal;
    public static Predicate<Entity> predicate = entity -> {
        if (entity instanceof Animal) {
            Animal animal = (Animal)entity;
            return !animal.isInLove() && !animal.isBaby() && animal.getAge() == 0;
        }
        return false;
    };

    public CupidBee(EntityType<? extends Bee> entityType, Level world) {
        super(entityType, world);
        this.setAttributeValue(GeneAttribute.WEATHER_TOLERANCE, GeneValue.WEATHER_TOLERANCE_RAIN);
    }

    @Override
    public boolean canSelfBreed() {
        return false;
    }

    @Override
    protected void registerGoals() {
        this.registerBaseGoals();
        this.goalSelector.removeGoal((Goal)this.breedGoal);
        this.beePollinateGoal = new ProductiveBee.PollinateGoal(this);
        this.goalSelector.addGoal(4, (Goal)this.beePollinateGoal);
        this.goToKnownFlowerGoal = new Bee.BeeGoToKnownFlowerGoal((Bee)this);
        this.goalSelector.addGoal(6, (Goal)this.goToKnownFlowerGoal);
        this.goalSelector.addGoal(2, (Goal)new GoToBreedableGoal());
        this.loveGoal = new SetLoveModeGoal();
        this.goalSelector.addGoal(3, (Goal)this.loveGoal);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.tickCount % 20 == 0 && this.hasNectar()) {
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            this.level().addParticle((ParticleOptions)ParticleTypes.HEART, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), d0, d1, d2);
        }
    }

    private int getAnimalsBredSincePollination() {
        return this.animalsBredSincePollination;
    }

    private void resetBreedCounter() {
        this.animalsBredSincePollination = 0;
    }

    private void addBreedCounter() {
        ++this.animalsBredSincePollination;
    }

    @Override
    public boolean wantsToEnterHive() {
        return super.wantsToEnterHive() && !this.loveGoal.isRunning();
    }

    public void dropOffNectar() {
        super.dropOffNectar();
        this.resetBreedCounter();
    }

    public List<Entity> findNearbyBreedables(float distance) {
        BlockPos pos = this.blockPosition();
        return this.level().getEntities((Entity)this, new AABB(pos).inflate((double)distance, (double)distance, (double)distance), predicate);
    }

    public class GoToBreedableGoal
    extends Goal {
        private int ticks = 0;

        public boolean canUse() {
            return !CupidBee.this.isAngry() && CupidBee.this.hasNectar() && CupidBee.this.targetEntity != null;
        }

        public boolean canContinueToUse() {
            return CupidBee.this.targetEntity != null && CupidBee.this.targetEntity.position().distanceTo(CupidBee.this.targetEntity.position()) > 2.0;
        }

        public void start() {
            this.ticks = 0;
        }

        public void tick() {
            if (CupidBee.this.targetEntity != null) {
                ++this.ticks;
                if (this.ticks > 600) {
                    CupidBee.this.targetEntity = null;
                } else if (!CupidBee.this.navigation.isDone() || this.ticks % 100 == 0) {
                    BlockPos blockPos = CupidBee.this.targetEntity.blockPosition();
                    CupidBee.this.navigation.moveTo((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), 1.0);
                }
            }
        }
    }

    public class SetLoveModeGoal
    extends Goal {
        private int ticks = 0;
        private boolean running;

        public boolean canUse() {
            List<Entity> breedablesNearby;
            if (!CupidBee.this.isAngry() && CupidBee.this.hasNectar() && CupidBee.this.getAnimalsBredSincePollination() <= (Integer)ProductiveBeesConfig.BEES.cupidBeeAnimalsPerPollination.get() && !(breedablesNearby = CupidBee.this.findNearbyBreedables(5.0f)).isEmpty() && breedablesNearby.size() < (Integer)ProductiveBeesConfig.BEES.cupidBeeAnimalDensity.get()) {
                BlockPos beePos = CupidBee.this.blockPosition();
                Animal nearest = null;
                double nearestDistance = 0.0;
                for (Entity entity : breedablesNearby) {
                    if (!(entity instanceof Animal)) continue;
                    BlockPos pos = entity.blockPosition();
                    double distance = pos.distSqr((Vec3i)beePos);
                    if (nearestDistance != 0.0 && !(distance < nearestDistance)) continue;
                    nearestDistance = distance;
                    nearest = (Animal)entity;
                }
                CupidBee.this.targetEntity = nearest;
                return true;
            }
            return false;
        }

        public boolean canContinueToUse() {
            if (!this.running) {
                return false;
            }
            return CupidBee.this.targetEntity != null && CupidBee.this.hasNectar() && !CupidBee.this.isAngry();
        }

        public boolean isRunning() {
            return this.running;
        }

        public void start() {
            this.ticks = 0;
            this.running = true;
        }

        public void stop() {
            this.running = false;
        }

        public void tick() {
            ++this.ticks;
            if (CupidBee.this.targetEntity != null) {
                if (this.ticks > 600) {
                    CupidBee.this.targetEntity = null;
                } else {
                    Vec3 vec3d = CupidBee.this.targetEntity.position().add(0.5, (double)0.6f, 0.5);
                    double distanceToTarget = vec3d.distanceTo(CupidBee.this.position());
                    if (distanceToTarget > 1.0) {
                        this.moveToNextTarget(vec3d);
                    } else if (distanceToTarget > 0.1 && this.ticks > 600) {
                        CupidBee.this.targetEntity = null;
                    } else {
                        Entity target;
                        List<Entity> breedablesNearby = CupidBee.this.findNearbyBreedables(1.0f);
                        if (!breedablesNearby.isEmpty() && (target = breedablesNearby.iterator().next()) instanceof Animal) {
                            if (!((Animal)target).isBaby() && ((Animal)target).canFallInLove()) {
                                ((Animal)target).setInLove(null);
                                CupidBee.this.addBreedCounter();
                            }
                            CupidBee.this.playSound(SoundEvents.BEE_POLLINATE, 1.0f, 1.0f);
                        }
                    }
                }
            }
        }

        private void moveToNextTarget(Vec3 target) {
            CupidBee.this.getMoveControl().setWantedPosition(target.x, target.y, target.z, 1.0);
        }
    }
}

