/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.metadata;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.cyclops.cyclopscore.metadata.IRegistryExportable;
import org.cyclops.cyclopscore.metadata.RegistryExportableRecipeAbstract;

public class RegistryExportableCraftingRecipe
extends RegistryExportableRecipeAbstract<RecipeType<CraftingRecipe>, CraftingRecipe, CraftingInput> {
    protected RegistryExportableCraftingRecipe() {
        super(() -> RecipeType.CRAFTING);
    }

    @Override
    public JsonObject serializeRecipe(RecipeHolder<CraftingRecipe> recipe) {
        JsonObject object = new JsonObject();
        NonNullList inputs = ((CraftingRecipe)recipe.value()).getIngredients();
        JsonArray arrayInputs = new JsonArray();
        for (Ingredient input : inputs) {
            JsonArray arrayInputAlternatives = new JsonArray();
            for (ItemStack inputAlternative : input.getItems()) {
                arrayInputAlternatives.add((JsonElement)IRegistryExportable.serializeItemStack(inputAlternative));
            }
            arrayInputs.add((JsonElement)arrayInputAlternatives);
        }
        object.addProperty("id", recipe.id().toString());
        object.add("input", (JsonElement)arrayInputs);
        object.add("output", (JsonElement)IRegistryExportable.serializeItemStack(((CraftingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)ServerLifecycleHooks.getCurrentServer().registryAccess())));
        if (recipe.value() instanceof ShapedRecipe) {
            object.addProperty("width", (Number)((ShapedRecipe)recipe.value()).getWidth());
            object.addProperty("height", (Number)((ShapedRecipe)recipe.value()).getHeight());
        }
        return object;
    }
}

