/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.configurabletypeaction;

import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ModelEvent;
import org.cyclops.cyclopscore.client.model.IDynamicModelElementCommon;
import org.cyclops.cyclopscore.config.configurabletypeaction.BlockAction;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfigCommon;
import org.cyclops.cyclopscore.init.ModBase;

@EventBusSubscriber(modid="cyclopscore", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class BlockActionNeoForgeAux
extends BlockAction<ModBase<?>> {
    @Override
    protected void polish(BlockConfigCommon<ModBase<?>> config) {
        IDynamicModelElementCommon dynamicModelElement;
        super.polish(config);
        if (((ModBase)config.getMod()).getModHelpers().getMinecraftHelpers().isClientSide() && (dynamicModelElement = config.getBlockClientConfig().getDynamicModelElement()) != null) {
            BlockAction.handleDynamicBlockModel(config);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onModelBakeEvent(ModelEvent.ModifyBakingResult event) {
        for (BlockConfigCommon config : MODEL_ENTRIES) {
            IDynamicModelElementCommon dynamicModelElement = config.getBlockClientConfig().getDynamicModelElement();
            BakedModel dynamicModel = dynamicModelElement.createDynamicModel(pair -> event.getModels().put((ModelResourceLocation)pair.getLeft(), (BakedModel)pair.getRight()));
            if (config.getBlockClientConfig().dynamicBlockVariantLocation != null) {
                event.getModels().put(config.getBlockClientConfig().dynamicBlockVariantLocation, dynamicModel);
            }
            if (config.getBlockClientConfig().dynamicItemVariantLocation == null) continue;
            event.getModels().put(config.getBlockClientConfig().dynamicItemVariantLocation, dynamicModel);
        }
    }
}

