/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.capability.fluid;

import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.templates.FluidHandlerItemStack;
import org.cyclops.cyclopscore.RegistryEntries;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerItemCapacity;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerMutable;

public class FluidHandlerItemCapacity
extends FluidHandlerItemStack
implements IFluidHandlerItemCapacity,
IFluidHandlerMutable {
    private final Fluid fluid;
    private final int capacityDefault;

    public FluidHandlerItemCapacity(ItemStack container, int capacity) {
        this(container, capacity, null);
    }

    public FluidHandlerItemCapacity(ItemStack container, int capacity, Fluid fluid) {
        super(RegistryEntries.COMPONENT_FLUID_CONTENT, container, capacity);
        this.fluid = fluid;
        this.capacityDefault = capacity;
    }

    public boolean canFillFluidType(FluidStack resource) {
        return this.fluid == null || resource == null || this.fluid == resource.getFluid();
    }

    protected void setFluid(FluidStack fluid) {
        if (fluid.isEmpty()) {
            this.container.remove(this.componentType);
        } else {
            this.container.set(this.componentType, (Object)SimpleFluidContent.copyOf((FluidStack)fluid));
        }
    }

    @Override
    public void setCapacity(int capacity) {
        if (capacity == this.capacityDefault) {
            this.getContainer().remove(RegistryEntries.COMPONENT_CAPACITY);
        } else {
            this.getContainer().set(RegistryEntries.COMPONENT_CAPACITY, (Object)capacity);
        }
        this.capacity = capacity;
    }

    @Override
    public int getCapacity() {
        return this.getContainer().has(RegistryEntries.COMPONENT_CAPACITY) ? (Integer)this.getContainer().get(RegistryEntries.COMPONENT_CAPACITY) : this.capacity;
    }

    @Nullable
    public FluidStack getFluid() {
        this.capacity = this.getCapacity();
        return super.getFluid();
    }

    @Override
    public void setFluidInTank(int tank, FluidStack fluidStack) {
        if (tank == 0) {
            this.setFluid(fluidStack);
        }
    }
}

