/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.workers.tools;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.creeperhost.polylib.data.serializable.BooleanData;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.neoforge.common.util.FakePlayer;
import vswe.stevescarts.api.StevesCartsAPI;
import vswe.stevescarts.api.farms.ITreeModule;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.api.modules.interfaces.ISuppliesModule;
import vswe.stevescarts.api.modules.template.ModuleTool;
import vswe.stevescarts.api.slots.SlotStevesCarts;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.containers.slots.SlotRepair;
import vswe.stevescarts.containers.slots.SlotSapling;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.BlockPosHelpers;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.modules.addons.plants.ModulePlantSize;
import vswe.stevescarts.polylib.EntityData;

public abstract class ModuleWoodcutter
extends ModuleTool
implements ISuppliesModule {
    private ArrayList<ITreeModule> treeModules;
    private ModulePlantSize plantSize;
    private boolean isPlanting;
    private float cutterAngle = 0.7853982f;
    private final EntityData<Boolean> isCutting = new EntityData(this.getCart(), new BooleanData(false));

    public ModuleWoodcutter(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public byte getWorkPriority() {
        return 80;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        this.drawString(guiGraphics, gui, Localization.MODULES.TOOLS.CUTTER.translate(new String[0]), 8, 6, 0x404040);
    }

    @Override
    protected int getInventoryWidth() {
        return super.getInventoryWidth() + 3;
    }

    @Override
    protected SlotStevesCarts getSlot(int slotId, int x, int y) {
        if (x == 0) {
            return super.getSlot(slotId, x, y);
        }
        return new SlotSapling(this.getCart(), this, slotId, 8 + --x * 18, 28 + y * 18);
    }

    @Override
    public boolean useDurability() {
        return true;
    }

    @Override
    public void init() {
        super.init();
        this.treeModules = new ArrayList();
        for (ModuleBase module : this.getCart().getModules()) {
            if (module instanceof ITreeModule) {
                this.treeModules.add((ITreeModule)((Object)module));
                continue;
            }
            if (!(module instanceof ModulePlantSize)) continue;
            this.plantSize = (ModulePlantSize)module;
        }
        this.treeModules.addAll(StevesCartsAPI.TREE_MODULES);
    }

    public abstract int getPercentageDropChance();

    public NonNullList<ItemStack> getTierDrop(List<ItemStack> baseItems) {
        NonNullList nerfedItems = NonNullList.create();
        for (ItemStack item : baseItems) {
            if (item.isEmpty()) continue;
            this.dropItemByMultiplierChance((List<ItemStack>)nerfedItems, item, this.getPercentageDropChance());
        }
        return nerfedItems;
    }

    private void dropItemByMultiplierChance(List<ItemStack> items, @Nonnull ItemStack item, int percentage) {
        while (percentage > 0) {
            if (this.getCart().random.nextInt(100) < percentage) {
                items.add(item.copy());
            }
            percentage -= 100;
        }
    }

    @Override
    public boolean work() {
        int i;
        Level world = this.getCart().level();
        BlockPos next = this.getNextblock();
        int size = this.getPlantSize();
        this.destroyLeaveBlockOnTrack(world, next);
        this.destroyLeaveBlockOnTrack(world, next.above());
        for (i = -size; i <= size; ++i) {
            BlockPos plant;
            if (i == 0) continue;
            int i2 = i;
            if (i2 < 0) {
                i2 = -size - i2 - 1;
            }
            if (!this.plant(size, plant = next.offset(this.getCart().z() != next.getZ() ? i2 : 0, -1, this.getCart().x() != next.getX() ? i2 : 0), next.getX(), next.getZ())) continue;
            this.setCutting(false);
            return true;
        }
        if (!this.isPlanting) {
            for (i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    BlockPos farm = next.offset(i, -1, j);
                    if (!this.farm(world, farm)) continue;
                    this.setCutting(true);
                    return true;
                }
            }
        }
        this.isPlanting = false;
        this.setCutting(false);
        return false;
    }

    private boolean plant(int size, BlockPos pos, int cx, int cz) {
        if (size == 1 ? (pos.getX() + pos.getZ()) % 2 == 0 : pos.getX() == cx && pos.getX() / size % 2 == 0 || pos.getZ() == cz && pos.getZ() / size % 2 == 0) {
            return false;
        }
        ItemStack sapling = ItemStack.EMPTY;
        for (int i = 0; i < this.getInventorySize(); ++i) {
            SlotStevesCarts slot = this.getSlots().get(i);
            if (!slot.containsValidItem() || slot instanceof SlotRepair) continue;
            sapling = this.getStack(i);
            break;
        }
        if (!sapling.isEmpty()) {
            if (this.doPreWork()) {
                if (this.isSaplingHandler(sapling) && this.plantSapling(this.getCart().level(), pos, sapling, this.getFakePlayer())) {
                    sapling.shrink(1);
                    this.startWorking(25);
                    this.isPlanting = true;
                    return true;
                }
                this.stopWorking();
                this.isPlanting = false;
            } else {
                this.stopWorking();
                this.isPlanting = false;
            }
        }
        return false;
    }

    public boolean plantSapling(Level world, BlockPos pos, ItemStack stack, FakePlayer fakePlayer) {
        SaplingBlock blockSapling;
        if (stack.isEmpty()) {
            return false;
        }
        Block block = Block.byItem((Item)stack.getItem());
        if (block instanceof SaplingBlock && (blockSapling = (SaplingBlock)block).defaultBlockState().canSurvive((LevelReader)world, pos.above()) && fakePlayer.mayUseItemAt(pos.above(), Direction.UP, stack) && world.getBlockState(pos.above()).isAir()) {
            world.setBlock(pos.above(), blockSapling.defaultBlockState(), 3);
            return true;
        }
        return false;
    }

    private boolean farm(Level world, BlockPos pos) {
        BlockState state;
        if (!this.isBroken() && this.isWoodHandler(state = world.getBlockState(pos = pos.above()), pos)) {
            ArrayList<BlockPos> checked = new ArrayList<BlockPos>();
            if (this.removeAt(world, pos, checked)) {
                return true;
            }
            this.stopWorking();
        }
        return false;
    }

    private boolean removeAt(Level world, BlockPos here, ArrayList<BlockPos> checked) {
        int basetime;
        checked.add(here);
        BlockState blockState = world.getBlockState(here);
        if (world.isEmptyBlock(here)) {
            return false;
        }
        if (checked.size() < 125 && BlockPosHelpers.getHorizontalDistToCartSquared(here, this.getCart()) < 175.0) {
            for (int type = 0; type < 2; ++type) {
                boolean hitWood = false;
                if (this.isLeavesHandler(blockState, here)) {
                    type = 1;
                } else if (type == 1) {
                    hitWood = true;
                }
                for (int x = -1; x <= 1; ++x) {
                    for (int y = 1; y >= 0; --y) {
                        for (int z = -1; z <= 1; ++z) {
                            BlockPos pos = here.offset(x, y, z);
                            BlockState currentState = world.getBlockState(pos);
                            if (currentState.isAir() || (!hitWood ? !this.isLeavesHandler(currentState, pos) : !this.isWoodHandler(currentState, pos)) || checked.contains(pos)) continue;
                            return this.removeAt(world, pos, checked);
                        }
                    }
                }
            }
        }
        int fortune = this.enchanter != null ? this.enchanter.getFortuneLevel() : 0;
        LootParams.Builder builder = new LootParams.Builder((ServerLevel)world).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY).withParameter(LootContextParams.ORIGIN, (Object)this.getCart().position());
        BlockEntity blockEntity = world.getBlockEntity(here);
        if (blockEntity != null) {
            builder.withParameter(LootContextParams.BLOCK_ENTITY, (Object)blockEntity);
        }
        List stuff = blockState.getDrops(builder);
        ArrayList dropList = new ArrayList();
        for (Object drop : dropList) {
            if (drop.isEmpty() || drop.getCount() <= 0) continue;
            stuff.add(drop);
        }
        NonNullList<ItemStack> nerfedstuff = this.getTierDrop(stuff);
        for (ItemStack iStack : nerfedstuff) {
            this.getCart().addItemToChest(iStack);
            if (iStack.getCount() == 0) continue;
            return false;
        }
        world.removeBlock(here, false);
        if (this.isLeavesHandler(blockState, here)) {
            basetime = 2;
            this.damageTool(1);
        } else {
            basetime = 25;
            this.damageTool(5);
        }
        int efficiency = this.enchanter != null ? this.enchanter.getEfficiencyLevel() : 0;
        this.startWorking((int)((double)basetime / Math.pow(1.3f, efficiency)));
        return true;
    }

    private void setCutting(boolean val) {
        this.isCutting.set(val);
    }

    protected boolean isCutting() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getIsCutting();
        }
        return this.isCutting.get();
    }

    public float getCutterAngle() {
        return this.cutterAngle;
    }

    @Override
    public void update() {
        super.update();
        boolean cuttingflag = this.isCutting();
        if (cuttingflag || this.cutterAngle != 0.7853982f) {
            boolean flag = false;
            if (!cuttingflag && this.cutterAngle < 0.7853982f) {
                flag = true;
            }
            this.cutterAngle = (float)((double)(this.cutterAngle + 0.9f) % (Math.PI * 2));
            if (!cuttingflag && this.cutterAngle > 0.7853982f && flag) {
                this.cutterAngle = 0.7853982f;
            }
        }
    }

    @Override
    public boolean haveSupplies() {
        for (int i = 0; i < this.getInventorySize(); ++i) {
            if (!this.getSlots().get(i).containsValidItem()) continue;
            return true;
        }
        return false;
    }

    public boolean isLeavesHandler(BlockState blockState, BlockPos pos) {
        return blockState.is(BlockTags.LEAVES) || blockState.is(BlockTags.BEEHIVES);
    }

    public boolean isWoodHandler(BlockState blockState, BlockPos pos) {
        return blockState.is(BlockTags.LOGS);
    }

    public boolean isSaplingHandler(@Nonnull ItemStack sapling) {
        return sapling.is(ItemTags.SAPLINGS);
    }

    private int getPlantSize() {
        if (this.plantSize != null) {
            return this.plantSize.getSize();
        }
        return 1;
    }

    private void destroyLeaveBlockOnTrack(Level world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        if (this.isLeavesHandler(state, pos)) {
            world.removeBlock(pos, false);
        }
    }
}

