/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.client.models.storages.tanks;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.architectury.fluid.FluidStack;
import net.creeperhost.polylib.client.model.Model3D;
import net.creeperhost.polylib.client.render.RenderUtils;
import net.creeperhost.polylib.client.render.fluid.FluidRenderHelper;
import net.creeperhost.polylib.client.render.rendertypes.FluidTankRenderType;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import vswe.stevescarts.api.client.ModelCartbase;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.modules.storages.tanks.ModuleTank;

public class ModelSideTanks
extends ModelCartbase {
    public ModelSideTanks() {
        super(ModelSideTanks.getTexturedModelData().bakeRoot(), ResourceHelper.getResource("/models/tanksModel.png"));
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                modelPartData.addOrReplaceChild("side" + i + j, CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, -3.0f, -0.5f, 12.0f, 6.0f, 1.0f), PartPose.offset((float)-2.0f, (float)-0.5f, (float)(-10.5f + (float)(i * 22) - 3.0f + (float)(j * 5))));
                modelPartData.addOrReplaceChild("topbot" + i + j, CubeListBuilder.create().texOffs(0, 7).addBox(-6.0f, -2.0f, -0.5f, 12.0f, 4.0f, 1.0f), PartPose.offsetAndRotation((float)-2.0f, (float)(-3.0f + (float)(j * 5)), (float)(-11.0f + (float)(i * 22)), (float)1.5707964f, (float)0.0f, (float)0.0f));
            }
            modelPartData.addOrReplaceChild("front" + i, CubeListBuilder.create().texOffs(26, 0).addBox(-2.0f, -2.0f, -0.5f, 4.0f, 4.0f, 1.0f), PartPose.offsetAndRotation((float)-7.5f, (float)-0.5f, (float)(-11.0f + (float)(i * 22)), (float)0.0f, (float)1.5707964f, (float)0.0f));
            modelPartData.addOrReplaceChild("back" + i, CubeListBuilder.create().texOffs(36, 0).addBox(-2.0f, -2.0f, -0.5f, 4.0f, 4.0f, 1.0f), PartPose.offsetAndRotation((float)4.5f, (float)-0.5f, (float)(-11.0f + (float)(i * 22)), (float)0.0f, (float)1.5707964f, (float)0.0f));
            modelPartData.addOrReplaceChild("tube1" + i, CubeListBuilder.create().texOffs(26, 5).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.offset((float)5.5f, (float)-0.5f, (float)(-11.0f + (float)(i * 22))));
            modelPartData.addOrReplaceChild("tube2" + i, CubeListBuilder.create().texOffs(26, 5).addBox(-2.0f, -1.0f, -1.0f, 4.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)7.5f, (float)-0.5f, (float)(-10.0f + (float)(i * 20)), (float)0.0f, (float)1.5707964f, (float)0.0f));
            modelPartData.addOrReplaceChild("connection" + i, CubeListBuilder.create().texOffs(36, 0).addBox(-2.0f, -2.0f, -0.5f, 4.0f, 4.0f, 1.0f), PartPose.offset((float)7.5f, (float)-0.5f, (float)(-8.5f + (float)(i * 17))));
        }
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)16);
    }

    @Override
    public RenderType getRenderType(ModuleBase moduleBase) {
        return RenderType.entityCutout((ResourceLocation)this.getTexture());
    }

    @Override
    public void applyEffects(ModuleBase module, PoseStack matrixStack, MultiBufferSource rtb, float yaw, float pitch, float roll) {
        super.applyEffects(module, matrixStack, rtb, yaw, pitch, roll);
        ModuleTank moduleTank = (ModuleTank)module;
        net.neoforged.neoforge.fluids.FluidStack fluidStack = moduleTank.getFluid();
        int light = 15;
        if (fluidStack != null && !fluidStack.isEmpty()) {
            matrixStack.pushPose();
            VertexConsumer buffer = rtb.getBuffer(FluidTankRenderType.RESIZABLE);
            matrixStack.mulPose(Axis.XP.rotationDegrees(180.0f));
            matrixStack.translate(-0.45, (double)-0.15f, -0.85);
            FluidStack fluidStackA = FluidStack.create((Fluid)fluidStack.getFluid(), (long)fluidStack.getAmount());
            matrixStack.scale(0.7f, FluidRenderHelper.getScale((int)moduleTank.getFluidAmount(), (int)moduleTank.getCapacity(), (boolean)fluidStack.isEmpty()) / 3.0f, 0.3f);
            RenderUtils.renderObject((Model3D)FluidRenderHelper.getFluidModel((FluidStack)fluidStackA, (int)1401), (PoseStack)matrixStack, (VertexConsumer)buffer, (int)RenderUtils.getColorARGB((FluidStack)fluidStackA, (float)0.2f), (int)RenderUtils.calculateGlowLight((int)light, (FluidStack)fluidStackA));
            matrixStack.popPose();
            matrixStack.pushPose();
            matrixStack.mulPose(Axis.XP.rotationDegrees(180.0f));
            matrixStack.translate(-0.45, -0.15, 0.55);
            matrixStack.scale(0.7f, FluidRenderHelper.getScale((int)moduleTank.getFluidAmount(), (int)moduleTank.getCapacity(), (boolean)fluidStack.isEmpty()) / 3.0f, 0.3f);
            RenderUtils.renderObject((Model3D)FluidRenderHelper.getFluidModel((FluidStack)fluidStackA, (int)1401), (PoseStack)matrixStack, (VertexConsumer)buffer, (int)RenderUtils.getColorARGB((FluidStack)fluidStackA, (float)0.2f), (int)RenderUtils.calculateGlowLight((int)light, (FluidStack)fluidStackA));
            matrixStack.popPose();
        }
    }
}

