/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.util;

import com.glodblock.github.modularbees.util.ChanceStack;
import com.glodblock.github.modularbees.util.GameUtil;
import cy.jdkdigital.productivebees.common.item.CombBlockItem;
import cy.jdkdigital.productivebees.common.item.Honeycomb;
import cy.jdkdigital.productivebees.common.recipe.CentrifugeRecipe;
import cy.jdkdigital.productivebees.init.ModDataComponents;
import cy.jdkdigital.productivebees.util.BeeHelper;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.common.recipe.TagOutputRecipe;
import it.unimi.dsi.fastutil.objects.Object2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CombCentrifugeLookup {
    private static final Object2ReferenceMap<ResourceLocation, Output> RL_MAP = new Object2ReferenceOpenHashMap();
    private static final IdentityHashMap<Item, Output> ITEM_MAP = new IdentityHashMap();
    private static final Object2ReferenceMap<ItemStack, Output> NBT_MAP = new Object2ReferenceOpenCustomHashMap(GameUtil.ITEM_HASH);

    private CombCentrifugeLookup() {
    }

    public static boolean query(Consumer<ItemStack> accepter, ItemStack comb, @NotNull Level world) {
        ResourceLocation type;
        if (comb.isEmpty()) {
            return false;
        }
        Item item = comb.getItem();
        Output cache = item instanceof Honeycomb || item instanceof CombBlockItem ? ((type = (ResourceLocation)comb.get(ModDataComponents.BEE_TYPE)) != null ? (Output)RL_MAP.get((Object)type) : (Output)NBT_MAP.get((Object)comb)) : (comb.isComponentsPatchEmpty() ? ITEM_MAP.get(item) : (Output)NBT_MAP.get((Object)comb));
        if (cache == null) {
            cache = CombCentrifugeLookup.lookupRecipe(comb, world);
        }
        if (cache != null) {
            cache.output(accepter, world.getRandom());
            return true;
        }
        return false;
    }

    @Nullable
    private static Output lookupRecipe(@NotNull ItemStack comb, @NotNull Level world) {
        ItemStack key = comb.copy();
        boolean isBlock = comb.getItem() instanceof BlockItem;
        if (comb.getItem() instanceof BlockItem) {
            key = BeeHelper.getSingleComb((ItemStack)comb);
        }
        if (key.isEmpty()) {
            return null;
        }
        InventoryHandlerHelper.BlockEntityItemStackHandler inv = new InventoryHandlerHelper.BlockEntityItemStackHandler(2);
        inv.setStackInSlot(1, key);
        RecipeHolder recipe = BeeHelper.getCentrifugeRecipe((Level)world, (InventoryHandlerHelper.BlockEntityItemStackHandler)inv);
        if (recipe == null) {
            return null;
        }
        Output output = new Output(((CentrifugeRecipe)recipe.value()).getRecipeOutputs().entrySet().stream().map(e -> ChanceStack.of((ItemStack)e.getKey(), CombCentrifugeLookup.mul4((TagOutputRecipe.ChancedOutput)e.getValue(), isBlock))).toList());
        Item item = key.getItem();
        if (item instanceof Honeycomb) {
            ResourceLocation type = (ResourceLocation)key.get(ModDataComponents.BEE_TYPE);
            if (type != null) {
                RL_MAP.put((Object)type, (Object)output);
            } else {
                NBT_MAP.put((Object)comb, (Object)output);
            }
        } else if (comb.isComponentsPatchEmpty()) {
            ITEM_MAP.put(comb.getItem(), output);
        } else {
            NBT_MAP.put((Object)comb, (Object)output);
        }
        return output;
    }

    private static TagOutputRecipe.ChancedOutput mul4(TagOutputRecipe.ChancedOutput origin, boolean enable) {
        if (!enable) {
            return origin;
        }
        float chance = origin.chance();
        if (chance * 4.0f < 1.0f) {
            return new TagOutputRecipe.ChancedOutput(origin.ingredient(), origin.min(), origin.max(), chance * 4.0f);
        }
        if (chance * 2.0f < 1.0f) {
            return new TagOutputRecipe.ChancedOutput(origin.ingredient(), origin.min() * 2, origin.max() * 2, chance * 2.0f);
        }
        return new TagOutputRecipe.ChancedOutput(origin.ingredient(), origin.min() * 4, origin.max() * 4, chance);
    }

    private static void clear() {
        RL_MAP.clear();
        NBT_MAP.clear();
        ITEM_MAP.clear();
    }

    @SubscribeEvent
    public static void onReload(OnDatapackSyncEvent event) {
        CombCentrifugeLookup.clear();
    }

    private record Output(List<ChanceStack> outputs) {
        void output(Consumer<ItemStack> collector, RandomSource random) {
            this.outputs.forEach(c -> c.get(collector, random));
        }
    }
}

