/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.util;

import cy.jdkdigital.productivelib.common.recipe.TagOutputRecipe;
import java.util.function.Consumer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;

public interface ChanceStack {
    public void get(Consumer<ItemStack> var1, RandomSource var2);

    public static ChanceStack of(ItemStack stack, TagOutputRecipe.ChancedOutput chancedOutput) {
        if (Mth.equal((float)chancedOutput.chance(), (float)1.0f)) {
            if (chancedOutput.max() == chancedOutput.min()) {
                return new CommonStack(stack.copyWithCount(chancedOutput.max()));
            }
            return new MutableAmountStack(stack, chancedOutput.max(), chancedOutput.min());
        }
        if (chancedOutput.max() == chancedOutput.min()) {
            return new ChanceStackImpl(stack, chancedOutput.chance());
        }
        return new MutableAmountChanceStack(stack, chancedOutput.max(), chancedOutput.min(), chancedOutput.chance());
    }

    public static ChanceStack partial(ChanceStack stack, float chance) {
        return (adder, random) -> {
            if (random.nextFloat() < chance) {
                stack.get(adder, random);
            }
        };
    }

    public record CommonStack(ItemStack output) implements ChanceStack
    {
        @Override
        public void get(Consumer<ItemStack> adder, RandomSource random) {
            adder.accept(this.output.copy());
        }
    }

    public record MutableAmountStack(ItemStack output, int max, int min) implements ChanceStack
    {
        @Override
        public void get(Consumer<ItemStack> adder, RandomSource random) {
            int amt = Mth.nextInt((RandomSource)random, (int)this.min, (int)this.max);
            adder.accept(this.output.copyWithCount(amt));
        }
    }

    public record ChanceStackImpl(ItemStack output, float chance) implements ChanceStack
    {
        @Override
        public void get(Consumer<ItemStack> adder, RandomSource random) {
            if (random.nextFloat() <= this.chance) {
                adder.accept(this.output.copy());
            }
        }
    }

    public record MutableAmountChanceStack(ItemStack output, int max, int min, float chance) implements ChanceStack
    {
        @Override
        public void get(Consumer<ItemStack> adder, RandomSource random) {
            if (random.nextFloat() <= this.chance) {
                int amt = Mth.nextInt((RandomSource)random, (int)this.min, (int)this.max);
                adder.accept(this.output.copyWithCount(amt));
            }
        }
    }
}

