/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.common.tileentities.hive;

import com.glodblock.github.glodium.util.GlodUtil;
import com.glodblock.github.modularbees.common.MBConfig;
import com.glodblock.github.modularbees.common.MBSingletons;
import com.glodblock.github.modularbees.common.caps.FluidHandlerHost;
import com.glodblock.github.modularbees.common.caps.ItemHandlerHost;
import com.glodblock.github.modularbees.common.tileentities.base.TileMBModularCore;
import com.glodblock.github.modularbees.common.tileentities.hive.TileBeehivePart;
import com.glodblock.github.modularbees.common.tileentities.hive.TileModularBeehive;
import com.glodblock.github.modularbees.util.ServerTickTile;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.EmptyFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.EmptyItemHandler;
import org.jetbrains.annotations.NotNull;

public class TileBeehiveExport
extends TileBeehivePart
implements ServerTickTile,
ItemHandlerHost,
FluidHandlerHost {
    private static final int AUTO_EXPORT_INTERVAL = (Integer)MBConfig.AUTO_EXPORT_INTERVAL.get();
    private final IItemHandler item = new ProxyItemInventory(this::getHostItemInventory);
    private final IFluidHandler fluid = new ProxyFluidInventory(this::getHostFluidInventory);
    private BlockCapabilityCache<IItemHandler, Direction> itemCache;
    private BlockCapabilityCache<IFluidHandler, Direction> fluidCache;
    private long tick = 0L;

    public TileBeehiveExport(BlockPos pos, BlockState state) {
        super(GlodUtil.getTileType(TileBeehiveExport.class, TileBeehiveExport::new, (Block)MBSingletons.MODULAR_EXPORT), pos, state);
    }

    private IItemHandler getHostItemInventory() {
        TileMBModularCore tileMBModularCore;
        if (this.isActive() && (tileMBModularCore = this.core) instanceof TileModularBeehive) {
            TileModularBeehive beehive = (TileModularBeehive)tileMBModularCore;
            return beehive.getItemInventory();
        }
        return EmptyItemHandler.INSTANCE;
    }

    private IFluidHandler getHostFluidInventory() {
        TileMBModularCore tileMBModularCore;
        if (this.isActive() && (tileMBModularCore = this.core) instanceof TileModularBeehive) {
            TileModularBeehive beehive = (TileModularBeehive)tileMBModularCore;
            return beehive.getFluidInventory();
        }
        return EmptyFluidHandler.INSTANCE;
    }

    public void onFacingChange() {
        this.itemCache = null;
        this.fluidCache = null;
        this.invalidateCapabilities();
    }

    @Override
    public IItemHandler getItemInventory() {
        return this.item;
    }

    @Override
    public IFluidHandler getFluidInventory() {
        return this.fluid;
    }

    @Override
    public void tickServer(Level world, BlockState state) {
        if (this.isActive()) {
            ++this.tick;
            if (this.tick % (long)AUTO_EXPORT_INTERVAL == 0L) {
                IFluidHandler fluidTarget;
                ItemStack stack;
                IItemHandler itemTarget;
                Direction facing = this.getFacing();
                if (this.itemCache == null) {
                    this.itemCache = BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)((ServerLevel)world), (BlockPos)this.getBlockPos().relative(facing), (Object)facing.getOpposite());
                }
                if (this.fluidCache == null) {
                    this.fluidCache = BlockCapabilityCache.create((BlockCapability)Capabilities.FluidHandler.BLOCK, (ServerLevel)((ServerLevel)world), (BlockPos)this.getBlockPos().relative(facing), (Object)facing.getOpposite());
                }
                if ((itemTarget = (IItemHandler)this.itemCache.getCapability()) != null) {
                    for (int x = 0; x < this.item.getSlots(); ++x) {
                        stack = this.item.getStackInSlot(x);
                        ItemStack stored = stack.copy();
                        for (int y = 0; y < itemTarget.getSlots() && !stack.isEmpty(); ++y) {
                            stack = itemTarget.insertItem(y, stack, false);
                        }
                        this.item.extractItem(x, stored.getCount() - stack.getCount(), false);
                    }
                }
                if ((fluidTarget = (IFluidHandler)this.fluidCache.getCapability()) != null) {
                    stack = this.fluid.getFluidInTank(0);
                    int filled = fluidTarget.fill((FluidStack)stack, IFluidHandler.FluidAction.EXECUTE);
                    this.fluid.drain(filled, IFluidHandler.FluidAction.EXECUTE);
                }
            }
        }
    }

    public Direction getFacing() {
        return MBSingletons.MODULAR_EXPORT.getFacing(this.getBlockState());
    }

    private record ProxyItemInventory(Supplier<IItemHandler> getter) implements IItemHandler
    {
        public int getSlots() {
            return this.getter.get().getSlots();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return this.getter.get().getStackInSlot(slot);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return this.getter.get().insertItem(slot, stack, simulate);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.getter.get().extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return this.getter.get().getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return this.getter.get().isItemValid(slot, stack);
        }
    }

    private record ProxyFluidInventory(Supplier<IFluidHandler> getter) implements IFluidHandler
    {
        public int getTanks() {
            return this.getter.get().getTanks();
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            return this.getter.get().getFluidInTank(tank);
        }

        public int getTankCapacity(int tank) {
            return this.getter.get().getTankCapacity(tank);
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            return this.getter.get().isFluidValid(tank, stack);
        }

        public int fill(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
            return this.getter.get().fill(resource, action);
        }

        @NotNull
        public FluidStack drain(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
            return this.getter.get().drain(resource, action);
        }

        @NotNull
        public FluidStack drain(int maxDrain, @NotNull IFluidHandler.FluidAction action) {
            return this.getter.get().drain(maxDrain, action);
        }
    }
}

