/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.common.tileentities.centrifuge;

import com.glodblock.github.glodium.util.GlodUtil;
import com.glodblock.github.modularbees.common.MBSingletons;
import com.glodblock.github.modularbees.common.caps.FluidHandlerHost;
import com.glodblock.github.modularbees.common.caps.ItemHandlerHost;
import com.glodblock.github.modularbees.common.inventory.MBFluidInventory;
import com.glodblock.github.modularbees.common.inventory.MBItemInventory;
import com.glodblock.github.modularbees.common.inventory.SlotListener;
import com.glodblock.github.modularbees.common.tileentities.base.TileMBModularComponent;
import com.glodblock.github.modularbees.common.tileentities.base.TileMBModularCore;
import com.glodblock.github.modularbees.common.tileentities.centrifuge.TileCentrifugePart;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivelib.registry.LibItems;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileModularCentrifuge
extends TileMBModularCore
implements ItemHandlerHost,
FluidHandlerHost,
SlotListener {
    public static final int FLUID_TANKS = 3;
    public static final int WAITING_TICKS = ProductiveBeesConfig.GENERAL.centrifugePoweredProcessingTime.getAsInt();
    @Nullable
    private ObjectSet<BlockPos> allPos;
    @Nullable
    private ObjectSet<ChunkPos> allChunk;
    public static final Set<Item> ACCEPT_UPGRADES = Set.of((Item)LibItems.UPGRADE_TIME.get(), (Item)LibItems.UPGRADE_TIME_2.get(), (Item)LibItems.UPGRADE_PRODUCTIVITY.get(), (Item)LibItems.UPGRADE_PRODUCTIVITY_2.get(), (Item)LibItems.UPGRADE_PRODUCTIVITY_3.get(), (Item)LibItems.UPGRADE_PRODUCTIVITY_4.get());
    protected final MBItemInventory upgrade = new MBItemInventory(this, 4, s -> ACCEPT_UPGRADES.contains(s.getItem())).setSlotLimit(1);
    protected final MBItemInventory inputs = new MBItemInventory(this, 3).inputOnly();
    protected final MBItemInventory outputs = new MBItemInventory(this, 9).outputOnly();
    private final IItemHandler exposed = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.outputs, this.inputs});
    private final MultiTank tanks;
    private float process = 0.0f;
    private float tickSpeed = 1.0f;
    private final List<ItemStack> sending = new ArrayList<ItemStack>();
    private boolean stuck = false;
    private int para = 1;

    public TileModularCentrifuge(BlockPos pos, BlockState state) {
        super(GlodUtil.getTileType(TileModularCentrifuge.class, TileModularCentrifuge::new, (Block)MBSingletons.MODULAR_CENTRIFUGE_CORE), pos, state);
        this.tanks = new MultiTank(new MBFluidInventory[]{new MBFluidInventory(this, 64000).outputOnly(), new MBFluidInventory(this, 64000).outputOnly(), new MBFluidInventory(this, 64000).outputOnly()});
    }

    @Override
    protected void logicTick(@NotNull Level world, BlockState state, List<TileMBModularComponent> components) {
    }

    public double getProcess() {
        return this.process;
    }

    public void setProcess(double value) {
        this.process = (float)value;
    }

    public void setTankFluid(int slot, FluidStack stack) {
        this.tanks.tanks[slot].setFluid(stack);
    }

    @Override
    public MBItemInventory getHandlerByName(String name) {
        return switch (name) {
            case "outputs" -> this.outputs;
            case "inputs" -> this.inputs;
            case "upgrade" -> this.upgrade;
            default -> null;
        };
    }

    @NotNull
    public Collection<BlockPos> getPoses() {
        if (this.allPos == null) {
            this.allPos = new ObjectOpenHashSet();
            Direction face = MBSingletons.MODULAR_CENTRIFUGE_CORE.getFacing(this.getBlockState());
            if (face == null) {
                return this.allPos;
            }
            BlockPos corePos = this.getBlockPos();
            for (int y = corePos.getY() - 1; y <= corePos.getY() + 1; ++y) {
                int lowerX;
                int upperX;
                int lowerZ;
                int upperZ;
                if (face.getAxis() == Direction.Axis.X) {
                    upperZ = corePos.getZ() + 1;
                    lowerZ = corePos.getZ() - 1;
                    upperX = corePos.getX() + (-face.getStepX() + 1);
                    lowerX = corePos.getX() - (face.getStepX() + 1);
                } else if (face.getAxis() == Direction.Axis.Z) {
                    upperZ = corePos.getZ() + (-face.getStepZ() + 1);
                    lowerZ = corePos.getZ() - (face.getStepZ() + 1);
                    upperX = corePos.getX() + 1;
                    lowerX = corePos.getX() - 1;
                } else {
                    return this.allPos;
                }
                if (y == corePos.getY() - 1) {
                    this.allPos.add((Object)new BlockPos(upperX, y, upperZ));
                    this.allPos.add((Object)new BlockPos(upperX, y, lowerZ));
                    this.allPos.add((Object)new BlockPos(lowerX, y, upperZ));
                    this.allPos.add((Object)new BlockPos(lowerX, y, lowerZ));
                    continue;
                }
                for (int x = lowerX; x <= upperX; ++x) {
                    for (int z = lowerZ; z <= upperZ; ++z) {
                        this.allPos.add((Object)new BlockPos(x, y, z));
                    }
                }
            }
        }
        return this.allPos;
    }

    @NotNull
    public Collection<ChunkPos> getChunks() {
        if (this.allChunk == null) {
            this.allChunk = new ObjectOpenHashSet();
            for (BlockPos pos : this.getPoses()) {
                this.allChunk.add((Object)new ChunkPos(pos));
            }
        }
        return this.allChunk;
    }

    @Override
    public void onStateChange() {
        this.allChunk = null;
        this.allPos = null;
        super.onStateChange();
    }

    @Override
    public void saveTag(CompoundTag data, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveTag(data, provider);
        data.put("outputs", (Tag)this.outputs.serializeNBT(provider));
        data.put("inputs", (Tag)this.inputs.serializeNBT(provider));
        data.put("upgrade", (Tag)this.upgrade.serializeNBT(provider));
        data.put("tanks", (Tag)this.tanks.serializeNBT(provider));
        data.putFloat("process", this.process);
    }

    @Override
    public void loadTag(CompoundTag data, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadTag(data, provider);
        this.outputs.deserializeNBT(provider, data.getCompound("outputs"));
        this.inputs.deserializeNBT(provider, data.getCompound("inputs"));
        this.upgrade.deserializeNBT(provider, data.getCompound("upgrade"));
        this.tanks.deserializeNBT(provider, data.getCompound("tanks"));
        this.process = data.getFloat("process");
    }

    @Override
    public boolean isStructurePos(BlockPos pos) {
        Direction face = MBSingletons.MODULAR_CENTRIFUGE_CORE.getFacing(this.getBlockState());
        if (face == null) {
            return false;
        }
        return this.getPoses().contains(pos);
    }

    @Override
    public boolean isStructurePos(ChunkPos pos) {
        Direction face = MBSingletons.MODULAR_CENTRIFUGE_CORE.getFacing(this.getBlockState());
        if (face == null) {
            return false;
        }
        return this.getChunks().contains(pos);
    }

    @Override
    protected boolean buildStructure(Consumer<TileMBModularComponent> collector, Level world) {
        Direction face = MBSingletons.MODULAR_CENTRIFUGE_CORE.getFacing(this.getBlockState());
        if (face == null) {
            return false;
        }
        Collection<BlockPos> poses = this.getPoses();
        if (poses.isEmpty()) {
            return false;
        }
        for (BlockPos pos : poses) {
            TileCentrifugePart centrifugePart;
            if (pos.equals((Object)this.getBlockPos())) continue;
            BlockEntity te = world.getBlockEntity(pos);
            if (te instanceof TileCentrifugePart && !(centrifugePart = (TileCentrifugePart)te).isActive()) {
                collector.accept(centrifugePart);
                continue;
            }
            return false;
        }
        return true;
    }

    public void onLoad() {
        super.onLoad();
        this.updateUpgrade();
    }

    @Override
    public void onChange(IItemHandler inv, int slot) {
        if (inv == this.upgrade) {
            this.updateUpgrade();
        } else if (inv == this.outputs) {
            this.stuck = false;
        }
    }

    @Override
    public IFluidHandler getFluidInventory() {
        return this.tanks;
    }

    @Override
    public IItemHandler getItemInventory() {
        return this.exposed;
    }

    private void updateUpgrade() {
        this.tickSpeed = (float)(1.0 / (1.0 - (Double)ProductiveBeesConfig.UPGRADES.timeBonus.get() * (double)(this.upgrade.countStack((Item)LibItems.UPGRADE_TIME.get()) + 2 * this.upgrade.countStack((Item)LibItems.UPGRADE_TIME_2.get()))));
        this.para = 0;
        this.para += this.upgrade.countStack((Item)LibItems.UPGRADE_PRODUCTIVITY.get()) * 4;
        this.para += this.upgrade.countStack((Item)LibItems.UPGRADE_PRODUCTIVITY_2.get()) * 8;
        this.para += this.upgrade.countStack((Item)LibItems.UPGRADE_PRODUCTIVITY_3.get()) * 16;
        this.para += this.upgrade.countStack((Item)LibItems.UPGRADE_PRODUCTIVITY_4.get()) * 32;
        if (this.para <= 0) {
            this.para = 1;
        }
    }

    private record MultiTank(MBFluidInventory[] tanks) implements IFluidHandler,
    INBTSerializable<CompoundTag>
    {
        public int getTanks() {
            return this.tanks.length;
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            return this.tanks[tank].getFluid();
        }

        public int getTankCapacity(int tank) {
            return this.tanks[tank].getCapacity();
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            return this.tanks[tank].isFluidValid(stack);
        }

        public int fill(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
            return 0;
        }

        public int forceFill(FluidStack resource, IFluidHandler.FluidAction action) {
            int filled;
            if (resource.isEmpty()) {
                return 0;
            }
            int tot = resource.getAmount();
            for (MBFluidInventory tank : this.tanks) {
                if (resource.isEmpty()) {
                    return tot;
                }
                if (!tank.getFluid().is(resource.getFluid())) continue;
                filled = tank.forceFill(resource, action);
                resource.shrink(filled);
            }
            for (MBFluidInventory tank : this.tanks) {
                if (resource.isEmpty()) {
                    return tot;
                }
                if (!tank.getFluid().isEmpty()) continue;
                filled = tank.forceFill(resource, action);
                resource.shrink(filled);
            }
            return tot - resource.getAmount();
        }

        @NotNull
        public FluidStack drain(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
            FluidStack fluid = resource.copy();
            for (MBFluidInventory tank : this.tanks) {
                if (resource.isEmpty()) {
                    return fluid;
                }
                FluidStack drained = tank.drain(resource, action);
                resource.shrink(drained.getAmount());
            }
            fluid.shrink(resource.getAmount());
            return fluid;
        }

        @NotNull
        public FluidStack drain(int maxDrain, @NotNull IFluidHandler.FluidAction action) {
            for (MBFluidInventory tank : this.tanks) {
                if (tank.getFluid().isEmpty()) continue;
                return this.drain(tank.getFluid().copyWithAmount(maxDrain), action);
            }
            return FluidStack.EMPTY;
        }

        public CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            CompoundTag nbt = new CompoundTag();
            for (int x = 0; x < this.tanks.length; ++x) {
                if (this.tanks[x].getFluid().isEmpty()) continue;
                CompoundTag tankTag = this.tanks[x].writeToNBT(provider, new CompoundTag());
                nbt.put("#" + x, (Tag)tankTag);
            }
            return nbt;
        }

        public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
            for (int x = 0; x < this.tanks.length; ++x) {
                if (nbt.contains("#" + x, 10)) {
                    CompoundTag tankTag = nbt.getCompound("#" + x);
                    this.tanks[x].readFromNBT(provider, tankTag);
                    continue;
                }
                this.tanks[x].setFluid(FluidStack.EMPTY);
            }
        }
    }
}

