/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.common.recipe;

import com.glodblock.github.modularbees.ModularBees;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record TreaterRecipe(Ingredient input, ItemStack output, float boost) implements Recipe<RecipeInput>
{
    public static final ResourceLocation ID = ModularBees.id("treater_food");
    public static final RecipeType<TreaterRecipe> TYPE = RecipeType.simple((ResourceLocation)ID);
    public static final RecipeSerializer<TreaterRecipe> SERIALIZER = new Serializer();

    public boolean matches(@NotNull RecipeInput input, @NotNull Level world) {
        return false;
    }

    @NotNull
    public ItemStack assemble(@NotNull RecipeInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return this.getResultItem(provider).copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return this.output.copy();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @NotNull
    public RecipeType<?> getType() {
        return TYPE;
    }

    public boolean isSpecial() {
        return true;
    }

    @NotNull
    public String getGroup() {
        return "treater";
    }

    public boolean isValidInput(ItemStack stack) {
        return this.input.test(stack);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        Ingredient input;
        ItemStack output = ItemStack.EMPTY;
        float boost = 1.0f;

        private Builder() {
        }

        public Builder input(ItemLike item) {
            this.input = Ingredient.of((ItemLike[])new ItemLike[]{item});
            return this;
        }

        public Builder input(TagKey<Item> tag) {
            this.input = Ingredient.of(tag);
            return this;
        }

        public Builder input(Ingredient input) {
            this.input = input;
            return this;
        }

        public Builder output(ItemLike item) {
            this.output = new ItemStack(item);
            return this;
        }

        public Builder output(ItemStack output) {
            this.output = output;
            return this;
        }

        public Builder boost(float boost) {
            this.boost = boost;
            return this;
        }

        public void save(RecipeOutput consumer, ResourceLocation id) {
            if (this.input == null || this.output == null) {
                throw new NullPointerException("Input and output cannot be null! %s".formatted(id));
            }
            if (this.boost < 1.0f) {
                throw new IllegalArgumentException("Boost must be greater than one! %s".formatted(id));
            }
            TreaterRecipe recipe = new TreaterRecipe(this.input, this.output, this.boost);
            consumer.accept(id, (Recipe)recipe, null);
        }
    }

    private static class Serializer
    implements RecipeSerializer<TreaterRecipe> {
        static final MapCodec<TreaterRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC.fieldOf("food").forGetter(r -> r.input), (App)ItemStack.OPTIONAL_CODEC.fieldOf("output").forGetter(r -> r.output), (App)Codec.FLOAT.fieldOf("boost").forGetter(r -> Float.valueOf(r.boost))).apply((Applicative)builder, TreaterRecipe::new));
        static final StreamCodec<RegistryFriendlyByteBuf, TreaterRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, r -> r.input, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, r -> r.output, (StreamCodec)ByteBufCodecs.FLOAT, r -> Float.valueOf(r.boost), TreaterRecipe::new);

        private Serializer() {
        }

        @NotNull
        public MapCodec<TreaterRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, TreaterRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

