/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.client.gui.elements;

import com.glodblock.github.modularbees.client.util.PicData;
import com.glodblock.github.modularbees.client.util.RelativeRect2i;
import com.glodblock.github.modularbees.client.util.TooltipElement;
import com.glodblock.github.modularbees.util.GameUtil;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class FluidTankDisplay
extends RelativeRect2i
implements Renderable,
TooltipElement {
    protected final Supplier<FluidStack> fluid;
    protected int capacity = 0;
    protected boolean showAmount = true;

    public FluidTankDisplay(Supplier<FluidStack> fluid) {
        this.fluid = fluid;
    }

    public FluidTankDisplay capacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    public FluidTankDisplay showAmount(boolean value) {
        this.showAmount = value;
        return this;
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        FluidStack fluid;
        if (this.contains(mouseX, mouseY)) {
            graphics.fillGradient(RenderType.guiOverlay(), this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, -2130706433, -2130706433, 0);
        }
        if ((fluid = this.fluid.get()) == null || fluid.isEmpty() || this.capacity == 0) {
            return;
        }
        IClientFluidTypeExtensions attributes = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(attributes.getStillTexture(fluid));
        PicData texture = PicData.of(sprite).color(attributes.getTintColor(fluid));
        int maxX = this.width;
        int maxY = this.getDisplayHeight(fluid.getAmount());
        Rect2i unit = texture.getSelect();
        for (int y = 0; y < maxY; y += unit.getHeight()) {
            for (int x = 0; x < maxX; x += unit.getWidth()) {
                int showX = Math.min(maxX - x, unit.getWidth());
                int showY = Math.min(maxY - y, unit.getHeight());
                texture.render(graphics, new Rect2i(unit.getX(), unit.getY(), showX, showY), new Rect2i(x + this.getX(), this.height - maxY + y + this.getY(), 0, 0));
            }
        }
    }

    protected int getDisplayHeight(int amount) {
        if (this.showAmount) {
            return Math.min(this.height, this.height * amount / this.capacity);
        }
        return this.height;
    }

    @Override
    public List<Component> getTooltipMessage(boolean isShift) {
        FluidStack fluid = this.fluid.get();
        if (fluid == null || fluid.isEmpty() || this.capacity == 0) {
            return List.of(Component.translatable((String)"modularbees.gui.empty"), Component.translatable((String)"modularbees.gui.fluid_tank.amount", (Object[])new Object[]{0, GameUtil.NUMBER_F.format(this.capacity)}));
        }
        return List.of(fluid.getHoverName(), Component.translatable((String)"modularbees.gui.fluid_tank.amount", (Object[])new Object[]{GameUtil.NUMBER_F.format(fluid.getAmount()), GameUtil.NUMBER_F.format(this.capacity)}));
    }

    @Override
    public boolean shouldDisplay(int mouseX, int mouseY) {
        return this.contains(mouseX, mouseY);
    }
}

