/*
 * Decompiled with CFR 0.152.
 */
package rainbows.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import net.minecraft.client.Camera;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import rainbows.client.ClientEventHandler;
import rainbows.config.Config;
import rainbows.util.RHelpers;
import rainbows.util.RainbowsData;

public class RainbowsRendererParticle
extends TextureSheetParticle {
    public final ResourceKey<Level> dimension;
    public final Player player;
    public final RainbowsData data;
    public static final ResourceLocation RAINBOW_TILE = RHelpers.identifier("textures/environment/tile.png");
    public double rainbowDoubleTick;
    public double rainbowTick;
    public static long oldGameTime;
    public float oldRainLevel;
    public static final double BRIGHTNESS_MIN_VALUE = 0.0;
    public static final double BRIGHTNESS_MAX_VALUE = 1.0;
    public static final double BRIGHTNESS_DELTA_INCREMENT = 1.0E-4;
    public double currentBrightnessValue = 0.0;
    public double deltaBrightness = 0.0;

    public RainbowsRendererParticle(ClientLevel level, Vec3 pos, Player player, RainbowsData data, ResourceKey<Level> dimension) {
        super(level, pos.x(), pos.y(), pos.z());
        this.dimension = dimension;
        this.player = player;
        this.data = data;
        this.lifetime = Integer.MAX_VALUE;
        this.hasPhysics = false;
        this.gravity = 0.0f;
        this.alpha = 0.0f;
    }

    public void tick() {
        if (RHelpers.RELOAD_RAINBOW_CONFIGS.isDown() || !this.isAlive()) {
            ClientEventHandler.HAS_RAINBOW.remove(this.dimension);
            this.remove();
            return;
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void render(VertexConsumer buffer, Camera camera, float partialTicks) {
        if (this.player == null || this.level == null) {
            return;
        }
        Vector3f lookVec = camera.getLookVector().normalize().mul(2.0f);
        Vector3f translatedVec = camera.getPosition().toVector3f().add((Vector3fc)lookVec);
        this.setPos(translatedVec.x(), translatedVec.y(), translatedVec.z());
        this.checkBiome(this.data, this.player, (Level)this.level);
        int startTick = 5000;
        float rainLevel = this.level.getRainLevel(partialTicks);
        float time = this.level.getTimeOfDay(partialTicks);
        double brightness = Mth.clamp((double)(Math.cos(Math.PI * 2 * (double)time) * 3.0), (double)0.0, (double)1.0);
        if (rainLevel < 0.2f && this.oldRainLevel > rainLevel && brightness > 0.0 && this.rainbowTick <= 0.0) {
            this.rainbowTick = 5000.0;
        }
        if (this.rainbowTick > 0.0) {
            Minecraft minecraft = Minecraft.getInstance();
            if (!(oldGameTime >= this.level.getGameTime() || minecraft.isLocalServer() && minecraft.isPaused())) {
                double isRainingAgainMod = rainLevel > 0.1f ? 50.0 * (double)rainLevel : 0.0;
                this.rainbowTick -= this.data.rainbowSpeed + isRainingAgainMod;
                this.rainbowDoubleTick += this.data.rainbowDoubleSpeed;
            }
            double alpha = Math.sin(Math.pow(this.rainbowTick * 3.544658838845707E-4, 2.0)) * brightness;
            double distance = this.data.rainbowDistance;
            PoseStack poseStack = new PoseStack();
            poseStack.pushPose();
            poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
            poseStack.mulPose(Axis.ZP.rotationDegrees(-((Double)Config.STARTUP.sunRotation.get()).floatValue()));
            poseStack.mulPose(Axis.XP.rotationDegrees(time * 360.0f + 90.0f));
            poseStack.translate(0.0, this.data.rainbowHeightOffset, distance);
            Matrix4f matrixTranslated = poseStack.last().pose();
            double doubleRainbowAlpha = Math.pow(RHelpers.noise(this.rainbowDoubleTick, 1L, 2, 0, 1, 1.0), 1.25);
            this.renderRainbow(buffer, true, this.data, minecraft, this.player, (Level)this.level, poseStack, matrixTranslated, alpha, distance, this.data.rainbowWidthDeg, this.data.rainbowHeightDeg, this.data.rainbowThickness, 1.0);
            this.renderRainbow(buffer, false, this.data, minecraft, this.player, (Level)this.level, poseStack, matrixTranslated, alpha * this.data.rainbowDoubleAlpha * doubleRainbowAlpha, distance, this.data.rainbowDoubleWidthDeg, this.data.rainbowDoubleHeightDeg, this.data.rainbowDoubleThickness, 0.0);
            poseStack.popPose();
        }
        oldGameTime = this.level.getGameTime();
        this.oldRainLevel = rainLevel;
    }

    public void renderRainbow(VertexConsumer buffer, boolean inner, RainbowsData data, Minecraft minecraft, Player player, Level level, PoseStack poseStack, Matrix4f matrix, double raininess, double distance, double radiusDegX, double radiusDegY, double thickness, double whiteAlphaFactor) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)RHelpers.identifier("textures/particles/white.png"));
        int detail = (Boolean)Config.STARTUP.globalDetailOverride.get() != false ? (Integer)Config.STARTUP.rainbowDetail.get() : data.rainbowDetail;
        double segments = Math.max((double)Math.round(minecraft.options.graphicsMode().get() == GraphicsStatus.FAST ? (double)detail * 0.25 : (double)detail), 16.0);
        if (segments == 0.0) {
            return;
        }
        double bandSegments = ((Integer)Config.STARTUP.rainbowColorDetail.get()).intValue();
        Color colorInner = RainbowsRendererParticle.getColor(data, 1.0);
        float rInner = (float)colorInner.getRed() / 255.0f;
        float gInner = (float)colorInner.getGreen() / 255.0f;
        float bInner = (float)colorInner.getBlue() / 255.0f;
        float aInner = (float)((double)((float)colorInner.getAlpha() / 255.0f) * raininess);
        double i0 = distance * Math.tan(Math.toRadians(radiusDegX));
        double o0 = distance * Math.tan(Math.toRadians(radiusDegX));
        double i1 = distance * Math.tan(Math.toRadians(radiusDegY));
        double o1 = distance * Math.tan(Math.toRadians(radiusDegY));
        float u = (float)(1.0 / (1.0 + bandSegments) * thickness);
        u = inner ? 1.0f - u : 1.0f + u;
        for (double l = 0.0; l < segments; l += 1.0) {
            double l0 = l / segments;
            double l1 = (l + 1.0) / segments;
            double angle0 = Math.PI * 2 * l0;
            double angle1 = Math.PI * 2 * l1;
            float x0 = (float)(Math.sin(angle0) * i0);
            float x1 = (float)(Math.sin(angle1) * o0);
            float y0 = (float)(Math.cos(angle0) * i1);
            float y1 = (float)(Math.cos(angle1) * o1);
            float[] coords = new float[]{x0, x1, y0, y1};
            for (double m = 0.0; m <= bandSegments; m += 1.0) {
                double m0 = m / bandSegments;
                Color color = RainbowsRendererParticle.brightenColor(RainbowsRendererParticle.getColor(data, m0), (int)(((Double)Config.STARTUP.rainbowBrightnessIncreaseFactor.get()).floatValue() * 255.0f));
                float r = (float)color.getRed() / 255.0f;
                float g = (float)color.getGreen() / 255.0f;
                float b = (float)color.getBlue() / 255.0f;
                float a = (float)((double)((float)color.getAlpha() / 255.0f) * raininess);
                coords = this.renderRainbowBand(buffer, poseStack, matrix, u, r, g, b, a, coords);
            }
            if (!inner) continue;
            coords = this.renderRainbowBand(buffer, poseStack, matrix, 0.0f, rInner, gInner, bInner, aInner, coords);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public float[] renderRainbowBand(VertexConsumer buffer, PoseStack poseStack, Matrix4f matrix, float u, float r, float g, float b, float a, float[] coords) {
        float alpha = Mth.clamp((float)a, (float)0.0f, (float)1.0f);
        float x0 = coords[0];
        float x1 = coords[1];
        float y0 = coords[2];
        float y1 = coords[3];
        float u0 = 1.0f;
        float u1 = 0.0f;
        float v0 = 1.0f;
        float v1 = 0.0f;
        int j = 0xF000F0;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        buffer.addVertex(poseStack.last().pose(), x0, y0, 0.0f).setUv(u1, v1).setColor(r, g, b, alpha).setLight(j).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
        buffer.addVertex(poseStack.last().pose(), x1, y1, 0.0f).setUv(u1, v0).setColor(r, g, b, alpha).setLight(j).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
        buffer.addVertex(poseStack.last().pose(), x1 *= u, y1 *= u, 0.0f).setUv(u0, v0).setColor(r, g, b, alpha).setLight(j).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
        buffer.addVertex(poseStack.last().pose(), x0 *= u, y0 *= u, 0.0f).setUv(u0, v1).setColor(r, g, b, alpha).setLight(j).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
        float[] newCoords = new float[]{x0, x1, y0, y1};
        return newCoords;
    }

    public static Color[] getColor(RainbowsData data) {
        Color[] colors = new Color[]{new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(1.0f, 0.0f, 0.0f, (float)data.alphaRed), new Color(1.0f, 0.5f, 0.0f, (float)data.alphaOrange), new Color(1.0f, 1.0f, 0.0f, (float)data.alphaYellow), new Color(0.0f, 1.0f, 0.0f, (float)data.alphaGreen), new Color(0.0f, 1.0f, 1.0f, (float)data.alphaCyan), new Color(0.0f, 0.0f, 1.0f, (float)data.alphaBlue), new Color(0.5f, 0.0f, 1.0f, (float)data.alphaViolet), new Color(1.0f, 1.0f, 1.0f, (float)data.alphaWhite)};
        return colors;
    }

    public static Color getColor(RainbowsData data, double value) {
        Color[] colors = RainbowsRendererParticle.getColor(data);
        if (value <= 0.0) {
            return colors[0];
        }
        if (value >= 1.0) {
            return colors[colors.length - 1];
        }
        double scaledValue = value * (double)(colors.length - 1);
        int index = (int)scaledValue;
        double fraction = scaledValue - (double)index;
        Color startColor = colors[index];
        Color endColor = colors[index + 1];
        float red = (float)((double)startColor.getRed() * (1.0 - fraction) + (double)endColor.getRed() * fraction);
        float green = (float)((double)startColor.getGreen() * (1.0 - fraction) + (double)endColor.getGreen() * fraction);
        float blue = (float)((double)startColor.getBlue() * (1.0 - fraction) + (double)endColor.getBlue() * fraction);
        float alpha = (float)((double)startColor.getAlpha() * (1.0 - fraction) + (double)endColor.getAlpha() * fraction);
        return new Color(red / 255.0f, green / 255.0f, blue / 255.0f, alpha / 255.0f);
    }

    public static Color brightenColor(Color color, int brightnessIncrease) {
        int red = Mth.clamp((int)(color.getRed() + brightnessIncrease), (int)0, (int)255);
        int green = Mth.clamp((int)(color.getGreen() + brightnessIncrease), (int)0, (int)255);
        int blue = Mth.clamp((int)(color.getBlue() + brightnessIncrease), (int)0, (int)255);
        return new Color(red, green, blue, color.getAlpha());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkBiome(RainbowsData data, Player player, Level level) {
        if (!data.allowedBiomes.isEmpty()) {
            ResourceKey biome = (ResourceKey)level.getBiome(player.blockPosition()).unwrapKey().get();
            if (biome == null) return;
            boolean validBiome = data.allowedBiomes.contains(level.registryAccess().lookupOrThrow(Registries.BIOME).getOrThrow(biome).toString());
            if (validBiome && this.deltaBrightness < 1.0) {
                this.deltaBrightness = Math.min(1.0, this.deltaBrightness + 1.0E-4);
                return;
            } else {
                if (validBiome) return;
                if (!(this.deltaBrightness > 0.0)) return;
                this.deltaBrightness = Math.max(0.0, this.deltaBrightness - 1.0E-4);
            }
            return;
        } else {
            if (!data.allowedBiomes.isEmpty() || !(this.deltaBrightness < 1.0)) return;
            this.deltaBrightness = Math.min(1.0, this.deltaBrightness + 1.0E-4);
        }
    }
}

