/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.evilcraft.RegistryEntries;

public class ItemPoisonBottle
extends Item {
    public ItemPoisonBottle(Item.Properties properties) {
        super(properties);
        NeoForge.EVENT_BUS.addListener(this::onPoisonRightClick);
    }

    public void onPoisonRightClick(PlayerInteractEvent.RightClickBlock event) {
        InteractionHand hand = event.getEntity().getUsedItemHand();
        if (hand != null && !event.getEntity().getItemInHand(hand).isEmpty() && event.getEntity().getItemInHand(hand).getItem() == Items.GLASS_BOTTLE) {
            BlockHitResult pos = ItemPoisonBottle.getPlayerPOVHitResult((Level)event.getLevel(), (Player)event.getEntity(), (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
            if (pos != null && pos.getType() == HitResult.Type.BLOCK) {
                BlockPos blockPos = BlockPos.containing((Position)pos.getLocation());
                if (event.getLevel().mayInteract(event.getEntity(), blockPos) && event.getEntity().mayUseItemAt(blockPos, event.getFace(), event.getEntity().getItemInHand(hand)) && event.getLevel().getBlockState(blockPos).getFluidState().is((Fluid)Fluids.WATER) && event.getLevel().getFluidState(blockPos).getType() == RegistryEntries.FLUID_POISON.get()) {
                    InventoryHelpers.tryReAddToStack((Player)event.getEntity(), (ItemStack)event.getEntity().getItemInHand(hand), (ItemStack)new ItemStack((ItemLike)this), (InteractionHand)hand);
                    event.getLevel().removeBlock(blockPos, false);
                    event.setCanceled(true);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ItemColor
    implements net.minecraft.client.color.item.ItemColor {
        public int getColor(ItemStack itemStack, int renderPass) {
            return renderPass == 0 ? Helpers.RGBAToInt((int)77, (int)117, (int)15, (int)255) : -1;
        }
    }
}

