/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import com.google.common.collect.Lists;
import java.util.Iterator;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.evilcraft.core.item.ItemBloodContainer;
import org.cyclops.evilcraft.item.ItemInvigoratingPendantConfig;

public class ItemInvigoratingPendant
extends ItemBloodContainer {
    private static final int TICK_MODULUS = 10;

    public ItemInvigoratingPendant(Item.Properties properties) {
        super(properties, ItemInvigoratingPendantConfig.capacity);
    }

    public void clearBadEffects(ItemStack itemStack, Player player) {
        int amount = ItemInvigoratingPendantConfig.usage;
        if (this.canConsume(amount, itemStack, player)) {
            int originalReducableDuration;
            int reducableDuration = originalReducableDuration = ItemInvigoratingPendantConfig.reduceDuration * 20;
            Iterator it = Lists.newLinkedList((Iterable)player.getActiveEffects()).iterator();
            while (reducableDuration > 0 && it.hasNext() && this.canConsume(amount, itemStack, player)) {
                MobEffectInstance effect = (MobEffectInstance)it.next();
                Holder potion = effect.getEffect();
                boolean shouldClear = true;
                if (potion != null) {
                    shouldClear = ((MobEffect)potion.value()).getCategory() == MobEffectCategory.HARMFUL;
                }
                if (!(shouldClear &= !effect.isAmbient())) continue;
                int reductionMultiplier = Math.max(1, effect.getAmplifier() + 1);
                int reducableDurationForThisEffect = reducableDuration / reductionMultiplier;
                int remaining = effect.getDuration();
                int toReduce = Math.min(reducableDurationForThisEffect, remaining);
                int toDrain = amount;
                reducableDuration -= toReduce;
                if (remaining == toReduce) {
                    player.removeEffect(potion);
                } else {
                    effect.duration = remaining - toReduce;
                    player.onEffectUpdated(effect, true, null);
                    toDrain = (int)Math.ceil((double)(reductionMultiplier * amount) * ((double)toReduce / (double)originalReducableDuration));
                }
                this.consume(toDrain, itemStack, player);
            }
        }
        if (ItemInvigoratingPendantConfig.fireUsage >= 0 && player.isOnFire() && this.canConsume(ItemInvigoratingPendantConfig.fireUsage, itemStack, player)) {
            player.clearFire();
            this.consume(ItemInvigoratingPendantConfig.fireUsage, itemStack, player);
        }
    }

    public void inventoryTick(ItemStack itemStack, Level world, Entity entity, int par4, boolean par5) {
        if (entity instanceof Player && WorldHelpers.efficientTick((Level)world, (int)10, (int[])new int[]{entity.getId()})) {
            this.clearBadEffects(itemStack, (Player)entity);
        }
        super.inventoryTick(itemStack, world, entity, par4, par5);
    }
}

