/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.evilcraft.RegistryEntries;

public abstract class ItemAbstractFocus
extends Item {
    private static final int TICK_MODULUS = 3;

    public ItemAbstractFocus(Item.Properties properties) {
        super(properties);
        if (MinecraftHelpers.isClientSide()) {
            this.registerProperties();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void registerProperties() {
        ItemProperties.register((Item)this, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"pull"), (ItemPropertyFunction)new ItemPropertyFunction(this){

            @OnlyIn(value=Dist.CLIENT)
            public float call(ItemStack stack, ClientLevel worldIn, LivingEntity entityIn, int id) {
                if (entityIn == null) {
                    return 0.0f;
                }
                ItemStack itemStack = entityIn.getUseItem();
                return !itemStack.isEmpty() && itemStack.getItem() instanceof ItemAbstractFocus ? (float)(stack.getUseDuration(entityIn) - entityIn.getUseItemRemainingTicks()) / 20.0f : 0.0f;
            }
        });
        ItemProperties.register((Item)this, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"pulling"), (ItemPropertyFunction)new ItemPropertyFunction(this){

            @OnlyIn(value=Dist.CLIENT)
            public float call(ItemStack stack, ClientLevel worldIn, LivingEntity entityIn, int id) {
                return entityIn != null && entityIn.isUsingItem() && entityIn.getUseItem() == stack ? 1.0f : 0.0f;
            }
        });
    }

    private int getItemInUseDuration(LivingEntity player) {
        return Math.max(0, player.getTicksUsingItem() - player.getUseItemRemainingTicks());
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (this.getItemInUseDuration((LivingEntity)player) > 0) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemStack);
        }
        player.startUsingItem(hand);
        return MinecraftHelpers.successAction((Object)itemStack);
    }

    public UseAnim getUseAnimation(ItemStack itemStack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity entity) {
        return Integer.MAX_VALUE;
    }

    public void releaseUsing(ItemStack itemStack, Level world, LivingEntity player, int duration) {
        if (player.level().isClientSide() && this.getItemInUseDuration(player) > 6) {
            player.playSound((SoundEvent)RegistryEntries.SOUNDEVENT_EFFECT_VENGEANCEBEAM_STOP.get(), 0.6f + player.level().random.nextFloat() * 0.2f, 1.0f);
        }
    }

    protected abstract ThrowableProjectile newBeamEntity(LivingEntity var1);

    public void onUseTick(Level level, LivingEntity player, ItemStack itemStack, int remaining) {
        int duration = this.getUseDuration(itemStack, player) - remaining;
        if (duration > 6) {
            if (WorldHelpers.efficientTick((Level)player.level(), (int)3, (int[])new int[]{player.getId()})) {
                ThrowableProjectile beam = this.newBeamEntity(player);
                if (!player.level().isClientSide()) {
                    beam.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 0.5f, 1.0f);
                    player.level().addFreshEntity((Entity)beam);
                }
            }
        } else if (duration == 3 && player.level().isClientSide()) {
            player.playSound((SoundEvent)RegistryEntries.SOUNDEVENT_EFFECT_VENGEANCEBEAM_START.get(), 0.6f + player.level().random.nextFloat() * 0.2f, 1.0f);
        }
    }
}

