/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.recipe.type;

import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.cyclopscore.helper.RecipeSerializerHelpers;
import org.cyclops.cyclopscore.recipe.ItemStackFromIngredient;
import org.cyclops.evilcraft.blockentity.BlockEntityBloodInfuserConfig;
import org.cyclops.evilcraft.core.recipe.type.RecipeBloodInfuser;

public class RecipeSerializerBloodInfuser
implements RecipeSerializer<RecipeBloodInfuser> {
    public static final MapCodec<RecipeBloodInfuser> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC_NONEMPTY.optionalFieldOf("input_item").forGetter(RecipeBloodInfuser::getInputIngredient), (App)FluidStack.CODEC.optionalFieldOf("input_fluid").forGetter(RecipeBloodInfuser::getInputFluid), (App)Codec.INT.optionalFieldOf("tier").forGetter(RecipeBloodInfuser::getInputTier), (App)RecipeSerializerHelpers.getCodecItemStackOrTag(() -> BlockEntityBloodInfuserConfig.recipeTagOutputModPriorities).fieldOf("output_item").forGetter(RecipeBloodInfuser::getOutputItem), (App)Codec.INT.fieldOf("duration").forGetter(RecipeBloodInfuser::getDuration), (App)Codec.FLOAT.optionalFieldOf("xp").forGetter(RecipeBloodInfuser::getXp)).apply((Applicative)builder, (inputIngredient, inputFluid, inputTier, outputItemStack, duration, xp) -> {
        if (inputIngredient.isEmpty() && inputFluid.isEmpty()) {
            throw new JsonSyntaxException("An input item or fluid is required");
        }
        if (inputTier.isPresent() && (Integer)inputTier.get() < 0) {
            throw new JsonSyntaxException("Tiers can not be negative");
        }
        if (duration <= 0) {
            throw new JsonSyntaxException("Durations must be higher than one tick");
        }
        if (xp.isPresent() && ((Float)xp.get()).floatValue() < 0.0f) {
            throw new JsonSyntaxException("XP can not be negative");
        }
        return new RecipeBloodInfuser((Optional<Ingredient>)inputIngredient, (Optional<FluidStack>)inputFluid, (Optional<Integer>)inputTier, (Either<ItemStack, ItemStackFromIngredient>)outputItemStack, (int)duration, (Optional<Float>)xp);
    }));
    public static final StreamCodec<RegistryFriendlyByteBuf, RecipeBloodInfuser> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC), RecipeBloodInfuser::getInputIngredient, (StreamCodec)ByteBufCodecs.optional((StreamCodec)FluidStack.STREAM_CODEC), RecipeBloodInfuser::getInputFluid, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.INT), RecipeBloodInfuser::getInputTier, (StreamCodec)RecipeSerializerHelpers.STREAM_CODEC_ITEMSTACK_OR_TAG, RecipeBloodInfuser::getOutputItem, (StreamCodec)ByteBufCodecs.INT, RecipeBloodInfuser::getDuration, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.FLOAT), RecipeBloodInfuser::getXp, RecipeBloodInfuser::new);

    public MapCodec<RecipeBloodInfuser> codec() {
        return CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, RecipeBloodInfuser> streamCodec() {
        return STREAM_CODEC;
    }
}

