/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.entity.ai;

import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public abstract class FollowOwnerGoal
extends Goal {
    public final Mob mob;
    private Player owner;
    private final LevelReader level;
    private final double speedModifier;
    private final PathNavigation navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private final float startDistance;
    private float oldWaterCost;
    private final boolean canFly;
    private final double teleportDistance;

    public FollowOwnerGoal(Mob mob, double speedModifier, float startDistance, float stopDistance, boolean canFly) {
        this.mob = mob;
        this.level = mob.level();
        this.speedModifier = speedModifier;
        this.navigation = mob.getNavigation();
        this.startDistance = startDistance;
        this.stopDistance = stopDistance;
        this.canFly = canFly;
        this.teleportDistance = (double)(this.startDistance * this.startDistance) * 2.0;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.mob.isLeashed()) {
            return false;
        }
        this.owner = this.getOwner().orElse(null);
        return this.owner != null && this.owner.level().dimension().equals(this.mob.level().dimension()) && !this.owner.isSpectator() && this.mob.distanceToSqr((Entity)this.owner) >= (double)(this.startDistance * this.startDistance);
    }

    public boolean canContinueToUse() {
        return !this.mob.isLeashed() && !this.navigation.isDone() && this.mob.distanceToSqr((Entity)this.owner) >= (double)(this.stopDistance * this.stopDistance);
    }

    public void start() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.mob.getPathfindingMalus(PathType.WATER);
        this.mob.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public void stop() {
        this.owner = null;
        this.navigation.stop();
        this.mob.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
    }

    public void tick() {
        this.mob.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.mob.getMaxHeadXRot());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.adjustedTickDelay(10);
            if (!this.mob.isLeashed() && !this.mob.isPassenger()) {
                if (this.requireTeleport()) {
                    this.teleportToOwner();
                } else {
                    this.navigation.moveTo((Entity)this.owner, this.speedModifier);
                }
            }
        }
    }

    private void teleportToOwner() {
        BlockPos blockpos = this.owner.blockPosition();
        for (int i = 0; i < 10; ++i) {
            if (!this.maybeTeleportTo(blockpos.getX() + this.randomIntInclusive(-3, 3), blockpos.getY() + this.randomIntInclusive(-1, 1), blockpos.getZ() + this.randomIntInclusive(-3, 3))) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int x, int y, int z) {
        if (Math.abs((double)x - this.owner.getX()) < 2.0 && Math.abs((double)z - this.owner.getZ()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(x, y, z))) {
            return false;
        }
        this.mob.moveTo((double)x + 0.5, (double)y, (double)z + 0.5, this.mob.getYRot(), this.mob.getXRot());
        this.navigation.stop();
        return true;
    }

    private boolean canTeleportTo(BlockPos pos) {
        PathType blockpathtypes = WalkNodeEvaluator.getPathTypeStatic((Mob)this.mob, (BlockPos)pos.mutable());
        if (blockpathtypes != PathType.WALKABLE) {
            return false;
        }
        BlockState blockstate = this.level.getBlockState(pos.below());
        if (!this.canFly && blockstate.getBlock() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = pos.subtract((Vec3i)this.mob.blockPosition());
        return this.level.noCollision((Entity)this.mob, this.mob.getBoundingBox().move(blockpos));
    }

    private int randomIntInclusive(int min, int max) {
        return this.mob.getRandom().nextInt(max - min + 1) + min;
    }

    protected abstract Optional<Player> getOwner();

    protected boolean requireTeleport() {
        return this.mob.distanceToSqr((Entity)this.owner) >= this.teleportDistance * Optional.ofNullable(this.mob.getTarget()).filter(LivingEntity::isAlive).map(e -> 2.0).orElse(1.0);
    }
}

