/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.BlockHorizontalWaterLogged;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.registry.ModBlocks;

public abstract class BlockGraveBase
extends BlockHorizontalWaterLogged {
    public static final IntegerProperty MODEL_TEXTURE = IntegerProperty.create((String)"model_texture", (int)0, (int)(BlockGraveMarble.MarbleType.values().length - 1));
    protected final GraveModel graveModel;

    public BlockGraveBase(BlockBehaviour.Properties builder, GraveModel graveModel) {
        super(builder.pushReaction(PushReaction.IGNORE).emissiveRendering((state, level, pos) -> true).lightLevel(state -> 5));
        this.graveModel = graveModel;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)MODEL_TEXTURE, (Comparable)Integer.valueOf(0)));
    }

    protected abstract MapCodec<? extends BlockGraveBase> codec();

    public String getDescriptionId() {
        return "tombstone.grave." + this.graveModel.getSerializedName();
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{MODEL_TEXTURE});
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter blockGetter, BlockPos pos, Entity entity) {
        return false;
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
    }

    public boolean dropFromExplosion(Explosion explosionIn) {
        return false;
    }

    public boolean canDropFromExplosion(BlockState state, BlockGetter blockGetter, BlockPos pos, Explosion explosion) {
        return false;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (player.isCreative()) {
            level.levelEvent(player, 2001, pos, BlockGraveBase.getId((BlockState)state));
            if (!level.isClientSide()) {
                DeathHandler.INSTANCE.removeAndEmptyPlayerGrave(level, pos);
            }
            return true;
        }
        return false;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!level.isClientSide() && (ModBlocks.isPlayerGrave(state.getBlock()) && !ModBlocks.isPlayerGrave(newState.getBlock()) || ModBlocks.isDecorativeGrave(state.getBlock()) && !ModBlocks.isDecorativeGrave(newState.getBlock()))) {
            if (DeathHandler.INSTANCE.canRemovePlayerGrave(level, pos)) {
                this.onDrop(level, pos, state);
            } else {
                Optional.ofNullable(level.getBlockEntity(pos)).ifPresent(grave -> {
                    CompoundTag oldNbt = grave.saveWithFullMetadata((HolderLookup.Provider)level.registryAccess());
                    CallbackHandler.addFastCallback(() -> {
                        level.setBlockAndUpdate(pos, state);
                        Optional.ofNullable(level.getBlockEntity(pos)).ifPresent(newGrave -> {
                            newGrave.loadWithComponents(oldNbt, (HolderLookup.Provider)level.registryAccess());
                            newGrave.setChanged();
                            level.sendBlockUpdated(pos, newState, state, 3);
                        });
                    });
                });
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    protected abstract void onDrop(Level var1, BlockPos var2, BlockState var3);

    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return this.graveModel.getShape((Direction)state.getValue((Property)FACING));
    }

    public GraveModel getGraveType() {
        return this.graveModel;
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> toCompare, BlockEntityType<E> entityType, BlockEntityTicker<? super E> ticker) {
        return entityType == toCompare ? ticker : null;
    }
}

