/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.screen;

import it.zerono.mods.extremereactors.CommonLocations;
import it.zerono.mods.extremereactors.api.reactor.ReactantType;
import it.zerono.mods.extremereactors.gamecontent.CommonConstants;
import it.zerono.mods.extremereactors.gamecontent.compat.patchouli.PatchouliCompat;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.CommonIcons;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.CommonMultiblockScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.MultiblockReactor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.container.ReactorSolidAccessPortContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorSolidAccessPortEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.variant.ReactorVariant;
import it.zerono.mods.zerocore.base.client.screen.BaseScreenToolTipsBuilder;
import it.zerono.mods.zerocore.base.client.screen.ClientBaseHelper;
import it.zerono.mods.zerocore.base.client.screen.control.MachineStatusIndicator;
import it.zerono.mods.zerocore.lib.client.gui.ButtonState;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.ToolTipsBuilder;
import it.zerono.mods.zerocore.lib.client.gui.control.AbstractButtonControl;
import it.zerono.mods.zerocore.lib.client.gui.control.Button;
import it.zerono.mods.zerocore.lib.client.gui.control.Panel;
import it.zerono.mods.zerocore.lib.client.gui.control.SlotsGroup;
import it.zerono.mods.zerocore.lib.client.gui.control.SwitchPictureButton;
import it.zerono.mods.zerocore.lib.client.gui.control.Table;
import it.zerono.mods.zerocore.lib.client.gui.layout.FixedLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.FlowLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.HorizontalAlignment;
import it.zerono.mods.zerocore.lib.client.gui.layout.ILayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalAlignment;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import it.zerono.mods.zerocore.lib.data.geometry.Point;
import it.zerono.mods.zerocore.lib.item.inventory.PlayerInventoryUsage;
import it.zerono.mods.zerocore.lib.multiblock.variant.IMultiblockVariant;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public class ReactorSolidAccessPortScreen
extends CommonMultiblockScreen<MultiblockReactor, ReactorSolidAccessPortEntity, ReactorSolidAccessPortContainer> {
    private final IControl _buttonsPanel;
    private final IControl _fuelInputGroup;
    private final IControl _wasteOutputGroup;
    private final IControl _playerInventoryGroup;
    private final IControl _playerHotBarGroup;

    public ReactorSolidAccessPortScreen(ReactorSolidAccessPortContainer container, Inventory inventory, Component title) {
        super(container, inventory, PlayerInventoryUsage.Both, title, ReactorSolidAccessPortScreen.mainTextureFromVariant((IMultiblockVariant)((ReactorSolidAccessPortEntity)container.getTileEntity()).getMultiblockVariant().orElse(ReactorVariant.Basic)));
        this.addPatchouliHelpButton(PatchouliCompat.HANDBOOK_ID, CommonLocations.REACTOR.buildWithSuffix("part-solidaccessport"), 1);
        SwitchPictureButton inputDirection = new SwitchPictureButton((ModContainerScreen)this, "directionInput", false, "direction");
        inputDirection.setDesiredDimension(16, 16);
        ClientBaseHelper.setButtonSpritesAndOverlayForState((AbstractButtonControl)inputDirection, (ButtonState)ButtonState.Default, (Supplier)CommonIcons.ButtonInputDirection);
        ClientBaseHelper.setButtonSpritesAndOverlayForState((AbstractButtonControl)inputDirection, (ButtonState)ButtonState.Active, (Supplier)CommonIcons.ButtonInputDirectionActive);
        inputDirection.Activated.subscribe(this::onInputActivated);
        inputDirection.setTooltips((ToolTipsBuilder)new BaseScreenToolTipsBuilder().addTranslatableAsTitle("gui.bigreactors.reactor.solidaccessport.directioninput.tooltip.title").addEmptyLine().addTranslatable("gui.bigreactors.reactor.solidaccessport.directioninput.tooltip.body"));
        SwitchPictureButton outputDirection = new SwitchPictureButton((ModContainerScreen)this, "directionOutput", false, "direction");
        outputDirection.setDesiredDimension(16, 16);
        ClientBaseHelper.setButtonSpritesAndOverlayForState((AbstractButtonControl)outputDirection, (ButtonState)ButtonState.Default, (Supplier)CommonIcons.ButtonOutputDirection);
        ClientBaseHelper.setButtonSpritesAndOverlayForState((AbstractButtonControl)outputDirection, (ButtonState)ButtonState.Active, (Supplier)CommonIcons.ButtonOutputDirectionActive);
        outputDirection.Activated.subscribe(this::onOutputActivated);
        outputDirection.setTooltips((ToolTipsBuilder)new BaseScreenToolTipsBuilder().addTranslatableAsTitle("gui.bigreactors.reactor.solidaccessport.directionoutput.tooltip.title").addEmptyLine().addTranslatable("gui.bigreactors.reactor.solidaccessport.directionoutput.tooltip.body"));
        container.DIRECTION.bind(direction -> {
            inputDirection.setActive(direction.isInput());
            outputDirection.setActive(direction.isOutput());
        });
        Button dumpFuel = new Button((ModContainerScreen)this, "dumpFuel", "");
        dumpFuel.setDesiredDimension(16, 16);
        dumpFuel.setPadding(0);
        dumpFuel.setIconForState(CommonIcons.ButtonDumpFuel.get(), ButtonState.Default);
        dumpFuel.setIconForState(CommonIcons.ButtonDumpFuelActive.get(), ButtonState.Active, ButtonState.ActiveHighlighted, new ButtonState[]{ButtonState.DefaultHighlighted});
        dumpFuel.Clicked.subscribe(this::onDumpFuel);
        dumpFuel.setTooltips((ToolTipsBuilder)new BaseScreenToolTipsBuilder().addTranslatableAsTitle("gui.bigreactors.reactor.solidaccessport.dumpfuel.tooltip.title").addEmptyLine().addTranslatable("gui.bigreactors.reactor.solidaccessport.dumpfuel.tooltip.body"));
        Button dumpWaste = new Button((ModContainerScreen)this, "dumpWaste", "");
        dumpWaste.setDesiredDimension(16, 16);
        dumpWaste.setPadding(0);
        dumpWaste.setIconForState(CommonIcons.ButtonDumpWaste.get(), ButtonState.Default);
        dumpWaste.setIconForState(CommonIcons.ButtonDumpWasteActive.get(), ButtonState.Active, ButtonState.ActiveHighlighted, new ButtonState[]{ButtonState.DefaultHighlighted});
        dumpWaste.Clicked.subscribe(this::onDumpWaste);
        dumpWaste.setTooltips((ToolTipsBuilder)new BaseScreenToolTipsBuilder().addTranslatableAsTitle("gui.bigreactors.reactor.solidaccessport.dumpwaste.tooltip.title").addEmptyLine().addTranslatable("gui.bigreactors.reactor.solidaccessport.dumpwaste.tooltip.body"));
        this._buttonsPanel = this.buttonsPanel((IControl)inputDirection, (IControl)outputDirection, (IControl)dumpFuel, (IControl)dumpWaste);
        this._fuelInputGroup = this.slotPanel("fuelinput", ReactantType.Fuel, CommonIcons.PortInputSlot);
        this._wasteOutputGroup = this.slotPanel("wasteoutput", ReactantType.Waste, CommonIcons.PortOutputSlot);
        this._playerInventoryGroup = this.createPlayerInventorySlotsGroupControl();
        this._playerHotBarGroup = this.createPlayerHotBarSlotsGroupControl();
    }

    @Override
    protected MachineStatusIndicator createStatusIndicator(ReactorSolidAccessPortContainer container) {
        return this.createReactorStatusIndicator(container.ACTIVE);
    }

    protected void onScreenCreate() {
        super.onScreenCreate();
        this.setContentLayoutEngine((ILayoutEngine)((VerticalLayoutEngine)((VerticalLayoutEngine)new VerticalLayoutEngine().setZeroMargins()).setVerticalAlignment(VerticalAlignment.Bottom)).setControlsSpacing(4));
        Table ioPane = new Table((ModContainerScreen)this, "ioPane", layout -> layout.columns(3, new int[]{54, 54, 54}).rows(1));
        ioPane.setDesiredDimension(162, 48);
        ioPane.addCellContent(this._buttonsPanel, hint -> hint.setHorizontalAlignment(HorizontalAlignment.Left).setVerticalAlignment(VerticalAlignment.Center));
        ioPane.addCellContent(this._fuelInputGroup, hint -> hint.setHorizontalAlignment(HorizontalAlignment.Center).setVerticalAlignment(VerticalAlignment.Center));
        ioPane.addCellContent(this._wasteOutputGroup, hint -> hint.setHorizontalAlignment(HorizontalAlignment.Center).setVerticalAlignment(VerticalAlignment.Center));
        this.addControl((IControl)ioPane);
        this.addControl(this._playerInventoryGroup);
        this.addControl(this._playerHotBarGroup);
    }

    private void onInputActivated(SwitchPictureButton button) {
        this.sendCommandToServer(CommonConstants.COMMAND_SET_INPUT);
    }

    private void onOutputActivated(SwitchPictureButton button) {
        this.sendCommandToServer(CommonConstants.COMMAND_SET_OUTPUT);
    }

    private void onDumpFuel(Button button, Integer mouseButton) {
        CompoundTag options = new CompoundTag();
        options.putBoolean("void", Screen.hasShiftDown());
        this.sendCommandToServer(CommonConstants.COMMAND_DUMP_FUEL, options);
    }

    private void onDumpWaste(Button button, Integer integer) {
        CompoundTag options = new CompoundTag();
        options.putBoolean("void", Screen.hasShiftDown());
        this.sendCommandToServer(CommonConstants.COMMAND_DUMP_WASTE, options);
    }

    private Panel buttonsPanel(IControl setInput, IControl setOutput, IControl dumpFuel, IControl dumpWaste) {
        Panel p = new Panel((ModContainerScreen)this, "buttons");
        p.setDesiredDimension(38, 38);
        p.setLayoutEngineHint(FixedLayoutEngine.hint((int)0, (int)5));
        p.setCustomBackgroundPainter((panel, matrix) -> {
            Point xy = panel.controlToScreen(0, 0);
            ISprite border = CommonIcons.ImageButtonBorder.get();
            int z = (int)panel.getGui().getZLevel();
            ModRenderHelper.paintSprite((GuiGraphics)matrix, (ISprite)border, (int)xy.X, (int)xy.Y, (int)z, (int)18, (int)18);
            ModRenderHelper.paintSprite((GuiGraphics)matrix, (ISprite)border, (int)(xy.X + 2 + 18), (int)xy.Y, (int)z, (int)18, (int)18);
            ModRenderHelper.paintSprite((GuiGraphics)matrix, (ISprite)border, (int)xy.X, (int)(xy.Y + 2 + 18), (int)z, (int)18, (int)18);
            ModRenderHelper.paintSprite((GuiGraphics)matrix, (ISprite)border, (int)(xy.X + 2 + 18), (int)(xy.Y + 2 + 18), (int)z, (int)18, (int)18);
        });
        p.setLayoutEngine((ILayoutEngine)((FlowLayoutEngine)((FlowLayoutEngine)((FlowLayoutEngine)new FlowLayoutEngine().setZeroMargins()).setVerticalMargin(1)).setHorizontalMargin(1)).setControlsSpacing(4));
        p.addControl(new IControl[]{setInput, setOutput, dumpFuel, dumpWaste});
        return p;
    }

    private Panel slotPanel(String groupName, ReactantType reactant, Supplier<@NotNull ISprite> slotBackground) {
        ISprite sprite = slotBackground.get();
        SlotsGroup sg = this.createSingleSlotGroupControl(groupName, reactant.name());
        Panel p = new Panel((ModContainerScreen)this);
        sg.setLayoutEngineHint(FixedLayoutEngine.hint((int)10, (int)10, (int)18, (int)18));
        p.setBackground(sprite);
        p.setDesiredDimension(sprite.getWidth(), sprite.getHeight());
        p.addControl((IControl)sg);
        return p;
    }
}

