/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.jei.common;

import com.refinedmods.refinedstorage.common.support.AbstractBaseScreen;
import com.refinedmods.refinedstorage.common.support.containermenu.FilterSlot;
import com.refinedmods.refinedstorage.common.support.packet.c2s.C2SPackets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

class FilterGhostIngredientHandler
implements IGhostIngredientHandler<AbstractBaseScreen> {
    FilterGhostIngredientHandler() {
    }

    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(AbstractBaseScreen screen, ITypedIngredient<I> ingredient, boolean doStart) {
        Object i = ingredient.getIngredient();
        if (i instanceof ItemStack) {
            ItemStack stack = (ItemStack)i;
            ArrayList<IGhostIngredientHandler.Target<I>> targets = new ArrayList<IGhostIngredientHandler.Target<I>>();
            for (Slot slot : screen.getMenu().slots) {
                FilterSlot filterSlot;
                if (!(slot instanceof FilterSlot) || !(filterSlot = (FilterSlot)slot).isActive() || !filterSlot.mayPlace(stack)) continue;
                Rect2i bounds = FilterGhostIngredientHandler.getBounds(screen, (Slot)filterSlot);
                targets.add(new TargetImpl(bounds, filterSlot.index));
            }
            return targets;
        }
        return Collections.emptyList();
    }

    private static Rect2i getBounds(AbstractBaseScreen screen, Slot slot) {
        return new Rect2i(screen.getLeftPos() + slot.x, screen.getTopPos() + slot.y, 17, 17);
    }

    public void onComplete() {
    }

    private static class TargetImpl<I>
    implements IGhostIngredientHandler.Target<I> {
        private final Rect2i area;
        private final int slotIndex;

        TargetImpl(Rect2i area, int slotIndex) {
            this.area = area;
            this.slotIndex = slotIndex;
        }

        public Rect2i getArea() {
            return this.area;
        }

        public void accept(I ingredient) {
            if (ingredient instanceof ItemStack) {
                ItemStack stack = (ItemStack)ingredient;
                C2SPackets.sendFilterSlotChange((ItemStack)stack, (int)this.slotIndex);
            }
        }
    }
}

