/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthetweaks.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.thevortex.allthetweaks.AllTheTweaks;
import com.thevortex.allthetweaks.config.cfgAoA;
import com.thevortex.allthetweaks.config.cfgExpert;
import com.thevortex.allthetweaks.config.cfgGrav;
import com.thevortex.allthetweaks.config.cfgLite;
import com.thevortex.allthetweaks.config.cfgMAGIC;
import com.thevortex.allthetweaks.config.cfgMain;
import com.thevortex.allthetweaks.config.cfgMon;
import com.thevortex.allthetweaks.config.cfgSKY;
import com.thevortex.allthetweaks.config.cfgSLOP;
import com.thevortex.allthetweaks.proxy.MyCons;
import java.nio.file.Path;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforgespi.Environment;
import org.apache.commons.lang3.tuple.Pair;

@EventBusSubscriber(modid="allthetweaks", bus=EventBusSubscriber.Bus.MOD)
public class Configuration {
    public static final ModConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    public static void loadConfig(ModConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.correct((CommentedConfig)configData);
        configData.save();
    }

    public static void bakeConfigs() {
        int SLOP = (Integer)Configuration.COMMON.mainmode.get();
        if (SLOP == 1) {
            AllTheTweaks.IPCC = cfgSLOP.IPCC;
            AllTheTweaks.ATM = cfgSLOP.ATM;
            AllTheTweaks.DISPLAY = cfgSLOP.DISPLAY;
            AllTheTweaks.BACKGROUND = cfgSLOP.BACKGROUND;
            return;
        }
        int SKY = (Integer)Configuration.COMMON.mainmode.get();
        if (SKY == 2) {
            AllTheTweaks.IPCC = cfgSKY.IPCC;
            AllTheTweaks.ATM = cfgSKY.ATM;
            AllTheTweaks.DISPLAY = cfgSKY.DISPLAY;
            AllTheTweaks.BACKGROUND = cfgSKY.BACKGROUND;
            return;
        }
        int MAGIC = (Integer)Configuration.COMMON.mainmode.get();
        if (MAGIC == 3) {
            AllTheTweaks.IPCC = cfgMAGIC.IPCC;
            AllTheTweaks.ATM = cfgMAGIC.ATM;
            AllTheTweaks.DISPLAY = cfgMAGIC.DISPLAY;
            AllTheTweaks.BACKGROUND = cfgMAGIC.BACKGROUND;
            return;
        }
        int EXPERT = (Integer)Configuration.COMMON.mainmode.get();
        if (EXPERT == 4) {
            AllTheTweaks.IPCC = cfgExpert.IPCC;
            AllTheTweaks.ATM = cfgExpert.ATM;
            AllTheTweaks.DISPLAY = cfgExpert.DISPLAY;
            AllTheTweaks.BACKGROUND = cfgExpert.BACKGROUND;
            return;
        }
        int GRAV = (Integer)Configuration.COMMON.mainmode.get();
        if (GRAV == 5) {
            AllTheTweaks.IPCC = cfgGrav.IPCC;
            AllTheTweaks.ATM = cfgGrav.ATM;
            AllTheTweaks.DISPLAY = cfgGrav.DISPLAY;
            AllTheTweaks.BACKGROUND = cfgGrav.BACKGROUND;
            return;
        }
        int LITE = (Integer)Configuration.COMMON.mainmode.get();
        if (LITE == 6) {
            AllTheTweaks.IPCC = cfgLite.IPCC;
            AllTheTweaks.ATM = cfgLite.ATM;
            AllTheTweaks.DISPLAY = cfgLite.DISPLAY;
            AllTheTweaks.BACKGROUND = cfgLite.BACKGROUND;
            return;
        }
        int AoA = (Integer)Configuration.COMMON.mainmode.get();
        if (AoA == 7) {
            AllTheTweaks.IPCC = cfgAoA.IPCC;
            AllTheTweaks.ATM = cfgAoA.ATM;
            AllTheTweaks.DISPLAY = cfgAoA.DISPLAY;
            AllTheTweaks.BACKGROUND = cfgAoA.BACKGROUND;
            return;
        }
        int Mon = (Integer)Configuration.COMMON.mainmode.get();
        if (Mon == 8) {
            AllTheTweaks.IPCC = cfgMon.IPCC;
            AllTheTweaks.ATM = cfgMon.ATM;
            AllTheTweaks.DISPLAY = cfgMon.DISPLAY;
            AllTheTweaks.BACKGROUND = cfgMon.BACKGROUND;
            return;
        }
        AllTheTweaks.IPCC = cfgMain.IPCC;
        AllTheTweaks.ATM = cfgMain.ATM;
        AllTheTweaks.DISPLAY = cfgMain.DISPLAY;
        AllTheTweaks.BACKGROUND = cfgMain.BACKGROUND;
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        Configuration.bakeConfigs();
        if (Environment.get().getDist() == Dist.CLIENT) {
            MyCons.setWindowIcon();
        }
    }

    @SubscribeEvent
    public static void onreLoad(ModConfigEvent.Reloading configEvent) {
        Configuration.bakeConfigs();
        if (Environment.get().getDist() == Dist.CLIENT) {
            MyCons.setWindowIcon();
        }
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ModConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ModConfigSpec.IntValue mainmode;
        public final ModConfigSpec.BooleanValue discord;
        public final ModConfigSpec.IntValue majorver;
        public final ModConfigSpec.IntValue minorver;
        public final ModConfigSpec.IntValue minorrevver;

        public Common(ModConfigSpec.Builder BUILDER) {
            BUILDER.push("packmode");
            this.mainmode = BUILDER.comment("ATM = 0 SLOP = 1 SKY = 2 MAGIC = 3 EXPERT = 4 GRAVITAS = 5 LITE = 6 AOA = 7 MON = 8").defineInRange("enable", 0, 0, 8);
            BUILDER.pop();
            BUILDER.push("discord");
            this.discord = BUILDER.comment("Enable Discord Rich Prescence").define("discord", true);
            BUILDER.pop();
            BUILDER.push("packversionmaj");
            this.majorver = BUILDER.comment("Pack Release Version Format : X").defineInRange("major", 1, 0, 32768);
            BUILDER.pop();
            BUILDER.push("packversionmin");
            this.minorver = BUILDER.comment("Pack Minor Version : X").defineInRange("minor", 0, 0, 32768);
            BUILDER.pop();
            BUILDER.push("packversionminrev");
            this.minorrevver = BUILDER.comment("Pack Minor Version Revision : X").defineInRange("minorrev", 0, 0, 32768);
            BUILDER.pop();
        }
    }
}

