/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthetweaks;

import com.thevortex.allthetweaks.AllTheTweaks;
import com.thevortex.repack.com.jagrosh.discordipc.ExtendedRichPresence;
import com.thevortex.repack.com.jagrosh.discordipc.IPCClient;
import com.thevortex.repack.com.jagrosh.discordipc.entities.DiscordBuild;
import com.thevortex.repack.com.jagrosh.discordipc.exceptions.NoDiscordClientException;
import java.time.OffsetDateTime;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.ModList;

@OnlyIn(value=Dist.CLIENT)
public class DRP {
    private static final IPCClient CLIENT = new IPCClient(AllTheTweaks.IPCC);
    private static boolean isEnabled = false;
    private static final OffsetDateTime TIME = OffsetDateTime.now();
    public static State currentState = new State(EnumState.STARTUP);
    private static int errorCount = 0;
    private static final Timer TIMER = new Timer("Discord Rich Presence Timer Thread");
    private static TimerTask timerTask;
    private static final int componentType = 2;
    private static final String buttonLabel = "Install on CurseForge";
    private static final String buttonUrl = "https://www.curseforge.com/minecraft/modpacks/all-the-mods-gravitas2/install";
    private static final int buttonStyle = 5;

    public static void start() {
        try {
            CLIENT.connect(new DiscordBuild[0]);
            timerTask = new TimerTask(){

                @Override
                public void run() {
                    DRP.setState(currentState);
                }
            };
            TIMER.schedule(timerTask, 1000L, 120000L);
            isEnabled = true;
        }
        catch (NoDiscordClientException noDiscordClientException) {
            // empty catch block
        }
    }

    public static void stop() {
        if (timerTask != null) {
            timerTask.cancel();
            timerTask = null;
        }
        try {
            CLIENT.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        errorCount = 0;
        isEnabled = false;
    }

    public static void setIdling() {
        DRP.setState(new State(EnumState.MENU));
    }

    public static void setDimension(ResourceKey<Level> world) {
        DRP.setState(DRP.getStateFromDimension(world));
    }

    public static State getStateFromDimension(ResourceKey<Level> world) {
        AllTheTweaks.LOGGER.debug(world.location().getPath());
        return DRP.getStateFromDimension(world.location().getPath());
    }

    public static void setState(State state) {
        block13: {
            currentState = state;
            ExtendedRichPresence.ExtendedBuilder builder = new ExtendedRichPresence.ExtendedBuilder();
            builder.setDetails(ModList.get().size() + " Mods");
            builder.setState(state.getState().getMessage(state.getReplace()));
            builder.setStartTimestamp(TIME);
            builder.setLargeImage(AllTheTweaks.ATM, AllTheTweaks.DISPLAY);
            if (state.getState() == EnumState.STARTUP) {
                builder.setLargeImage("mojang", "Loading");
                builder.setSmallImage(AllTheTweaks.ATM, AllTheTweaks.DISPLAY);
            }
            if (state.getState() == EnumState.MENU) {
                builder.setLargeImage(AllTheTweaks.ATM, AllTheTweaks.DISPLAY);
                builder.setSmallImage("mojang", "(c)");
            }
            if (state.getState() == EnumState.OVERWORLD) {
                builder.setLargeImage(AllTheTweaks.ATM, AllTheTweaks.DISPLAY);
                builder.setSmallImage("overworld", "In the Overworld");
            }
            if (state.getState() == EnumState.NETHER) {
                builder.setLargeImage(AllTheTweaks.ATM, AllTheTweaks.DISPLAY);
                builder.setSmallImage("nether", "In the Nether");
            }
            if (state.getState() == EnumState.END) {
                builder.setLargeImage(AllTheTweaks.ATM, AllTheTweaks.DISPLAY);
                builder.setSmallImage("end", "In the End");
            }
            if (state.getState() == EnumState.MINING) {
                builder.setLargeImage(AllTheTweaks.ATM, AllTheTweaks.DISPLAY);
                builder.setSmallImage("overworld", "In The Mining Dimension");
            }
            if (state.getState() == EnumState.OTHER) {
                builder.setLargeImage(AllTheTweaks.ATM, AllTheTweaks.DISPLAY);
                builder.setSmallImage("nether", "In the Other");
            }
            builder.setButton1(buttonLabel, buttonUrl);
            try {
                CLIENT.sendRichPresence(builder.build());
            }
            catch (Exception ex) {
                try {
                    CLIENT.connect(new DiscordBuild[0]);
                    errorCount = 0;
                    CLIENT.sendRichPresence(builder.build());
                }
                catch (Exception ex2) {
                    try {
                        CLIENT.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (++errorCount <= 10) break block13;
                    DRP.stop();
                }
            }
        }
    }

    public static boolean isEnabled() {
        return isEnabled;
    }

    public static State getCurrent() {
        return currentState;
    }

    public static void setDimension(DimensionType dimension) {
    }

    public static void setDimension(String path) {
        DRP.setState(DRP.getStateFromDimension(path));
    }

    private static State getStateFromDimension(String path) {
        switch (path) {
            case "the_nether": {
                return new State(EnumState.NETHER);
            }
            case "overworld": {
                return new State(EnumState.OVERWORLD);
            }
            case "the_end": {
                return new State(EnumState.END);
            }
            case "mining": {
                return new State(EnumState.MINING);
            }
            case "the_other": {
                return new State(EnumState.OTHER);
            }
        }
        return new State(EnumState.DIM, path);
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> DRP.stop(), "Discord Rich Presence Stop Thread"));
    }

    public static class State {
        private final EnumState state;
        private final String replace;

        public State(EnumState state) {
            this(state, "");
        }

        public State(EnumState state, String replace) {
            this.state = state;
            this.replace = replace;
        }

        public EnumState getState() {
            return this.state;
        }

        public String getReplace() {
            return this.replace;
        }
    }

    public static enum EnumState {
        STARTUP("Starting Minecraft", AllTheTweaks.ATM, AllTheTweaks.DISPLAY),
        MENU("Main Menu", AllTheTweaks.ATM, AllTheTweaks.DISPLAY),
        OVERWORLD("Dimension: Overworld", AllTheTweaks.ATM, AllTheTweaks.DISPLAY),
        NETHER("Dimension: The Nether", AllTheTweaks.ATM, AllTheTweaks.DISPLAY),
        END("Dimension: The End", AllTheTweaks.ATM, AllTheTweaks.DISPLAY),
        MINING("Dimension: Mining", AllTheTweaks.ATM, AllTheTweaks.DISPLAY),
        OTHER("Dimension: The Other", AllTheTweaks.ATM, AllTheTweaks.DISPLAY),
        DIM("Dimension: %s", AllTheTweaks.ATM, AllTheTweaks.DISPLAY);

        private final String message;
        private final String imagename;
        private final String imagekey;

        private EnumState(String message, String imagename, String imagekey) {
            this.message = message;
            this.imagename = imagename;
            this.imagekey = imagekey;
        }

        public String getMessage(String replace) {
            return this.message.replace("%s", replace);
        }

        public String getImageName(String replace) {
            return this.imagename.replace("%s", replace);
        }

        public String getImageKey() {
            return this.imagekey;
        }
    }
}

