/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.kubejstweaks.kubejs.kjs72.mixin.core.main;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.llamalad7.mixinextras.sugar.Local;
import dev.latvian.mods.kubejs.recipe.schema.JsonRecipeSchemaLoader;
import dev.uncandango.kubejstweaks.KubeJSTweaks;
import dev.uncandango.kubejstweaks.mixin.annotation.ConditionalMixin;
import java.util.Iterator;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.IModFileInfo;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

@ConditionalMixin(modId="kubejs", versionRange="[2101.7.2,2101.7.3)")
@Mixin(value={JsonRecipeSchemaLoader.class})
public class JsonRecipeSchemaLoaderMixin {
    @ModifyArg(method={"load"}, at=@At(value="INVOKE", target="Lcom/mojang/serialization/Codec;parse(Lcom/mojang/serialization/DynamicOps;Ljava/lang/Object;)Lcom/mojang/serialization/DataResult;"), index=1)
    private static Object checkVersion(Object par2, @Local ResourceLocation id) {
        JsonObject json;
        if (par2 instanceof JsonObject && (json = (JsonObject)par2).has("keys")) {
            Iterator it = json.getAsJsonArray("keys").iterator();
            while (it.hasNext()) {
                JsonObject keyJson;
                JsonElement key = (JsonElement)it.next();
                if (!(key instanceof JsonObject) || !(keyJson = (JsonObject)key).has("kubejstweaks:version_range")) continue;
                String range = keyJson.getAsJsonPrimitive("kubejstweaks:version_range").getAsString();
                String modId = id.getNamespace();
                KubeJSTweaks.LOGGER.debug("Mod id {} with conditional version {}", (Object)modId, (Object)range);
                try {
                    VersionRange rangeSpec = VersionRange.createFromVersionSpec((String)range);
                    IModFileInfo modFile = ModList.get().getModFileById(modId);
                    if (modFile != null) {
                        DefaultArtifactVersion modVersion = new DefaultArtifactVersion(modFile.versionString());
                        if (rangeSpec.containsVersion((ArtifactVersion)modVersion)) {
                            KubeJSTweaks.LOGGER.debug("Key component for type {} with version range {} matches with mod version {}.", new Object[]{id, range, modVersion});
                            continue;
                        }
                        KubeJSTweaks.LOGGER.debug("Key component for type {} with version range {} DOES NOT match with mod version {}.", new Object[]{id, range, modVersion});
                        it.remove();
                        continue;
                    }
                    KubeJSTweaks.LOGGER.warn("Mod {} was not found for key component type {}.", (Object)modId, (Object)id);
                }
                catch (InvalidVersionSpecificationException ex) {
                    KubeJSTweaks.LOGGER.error("Error evaluating version for a key component for mod: " + modId, (Throwable)ex);
                }
            }
        }
        return par2;
    }
}

