/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.potionsmaster.render.util;

import com.google.gson.Gson;
import com.thevortex.potionsmaster.PotionsMaster;
import com.thevortex.potionsmaster.render.util.BlockData;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.neoforged.fml.loading.FMLPaths;

public class BlockStoreBuilder {
    public static ArrayList<BlockData> list = new ArrayList();

    public static List<BlockData> scanFolder(Path folderPath) {
        boolean result;
        ArrayList<BlockData> blockDataList = new ArrayList<BlockData>();
        File folderFile = folderPath.toFile();
        if (!folderFile.exists() && !(result = folderFile.mkdirs())) {
            PotionsMaster.LOGGER.error("Couldn't create folder {}", (Object)folderPath);
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(folderPath, "*.json");){
            for (Path entry : stream) {
                BlockData blockData = BlockStoreBuilder.readJsonFile(entry);
                blockDataList.add(blockData);
            }
        }
        catch (IOException e) {
            PotionsMaster.LOGGER.error("Failed to read config folder", (Throwable)e);
        }
        return blockDataList;
    }

    @Nullable
    private static BlockData readJsonFile(Path filePath) {
        BlockData blockData;
        FileReader reader = new FileReader(filePath.toFile());
        try {
            blockData = (BlockData)new Gson().fromJson((Reader)reader, BlockData.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                PotionsMaster.LOGGER.error("Failed to read JSON file", (Throwable)e);
                return null;
            }
        }
        ((Reader)reader).close();
        return blockData;
    }

    public static void loadPotions(Path folderPath) {
        List<BlockData> blockDataList = BlockStoreBuilder.scanFolder(folderPath);
        list.addAll(blockDataList);
        PotionsMaster.blockStore.setStore(list);
    }

    public static void init() {
        Path folderPath = FMLPaths.CONFIGDIR.get().resolve("potionsmaster");
        BlockStoreBuilder.loadPotions(folderPath);
    }
}

