/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.neoforge.compat;

import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.food.FoodProperties;
import net.neoforged.neoforge.common.NeoForge;
import squeek.appleskin.ModConfig;
import squeek.appleskin.api.event.HUDOverlayEvent;
import squeek.appleskin.client.HUDOverlayHandler;
import squeek.appleskin.helpers.FoodHelper;
import terrails.colorfulhearts.api.heart.drawing.OverlayHeart;
import terrails.colorfulhearts.api.neoforge.event.NeoHeartRenderEvent;
import terrails.colorfulhearts.api.neoforge.event.NeoHeartUpdateEvent;
import terrails.colorfulhearts.compat.AppleSkinCommonCompat;
import terrails.colorfulhearts.neoforge.mixin.compat.appleskin.HUDOverlayHandlerAccessor;

public class AppleSkinCompat
extends AppleSkinCommonCompat {
    public AppleSkinCompat() {
        NeoForge.EVENT_BUS.addListener(this::onDefaultRender);
        NeoForge.EVENT_BUS.addListener(this::onPostRender);
        NeoForge.EVENT_BUS.addListener(this::heartChanged);
    }

    private void onDefaultRender(HUDOverlayEvent.HealthRestored event) {
        event.setCanceled(true);
    }

    private void onPostRender(NeoHeartRenderEvent.Post event) {
        LocalPlayer player = this.client.player;
        assert (player != null);
        if (!this.shouldDrawOverlay(event.getOverlayHeart().orElse(null), (Player)player)) {
            return;
        }
        FoodHelper.QueriedFoodResult result = HUDOverlayHandlerAccessor.getHeldFood().result(this.client.gui.getGuiTicks(), (Player)player);
        if (result == null) {
            HUDOverlayHandler.resetFlash();
            return;
        }
        float foodHealthIncrement = FoodHelper.getEstimatedHealthIncrement((Player)player, (FoodProperties)result.modifiedFoodProperties);
        float currentHealth = player.getHealth();
        float modifiedHealth = Math.min(currentHealth + foodHealthIncrement, player.getMaxHealth());
        if (modifiedHealth <= currentHealth) {
            return;
        }
        float alpha = HUDOverlayHandlerAccessor.getFlashAlpha();
        this.drawHealthOverlay(event.getGuiGraphics(), event.getX(), event.getY(), Mth.ceil((float)player.getAbsorptionAmount()), Mth.ceil((float)currentHealth), Mth.ceil((float)modifiedHealth), alpha, event.isHardcore());
    }

    private void heartChanged(NeoHeartUpdateEvent event) {
        this.lastHealth = 0;
    }

    public boolean shouldDrawOverlay(OverlayHeart overlayHeart, Player player) {
        if (overlayHeart != null) {
            return false;
        }
        if (!((Boolean)ModConfig.SHOW_FOOD_HEALTH_HUD_OVERLAY.get()).booleanValue()) {
            return false;
        }
        if (player.level().getDifficulty() == Difficulty.PEACEFUL) {
            return false;
        }
        FoodData stats = player.getFoodData();
        if (stats.getFoodLevel() >= 18) {
            return false;
        }
        return !player.hasEffect(MobEffects.REGENERATION);
    }
}

