/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.fastfurnace.mixin;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractFurnaceBlockEntity.class}, remap=false)
public abstract class MixinAbstractFurnaceBlockEntity
extends BaseContainerBlockEntity {
    @Unique
    @Nullable
    protected RecipeHolder<AbstractCookingRecipe> curRecipe;
    @Unique
    protected ItemStack failedMatch = ItemStack.EMPTY;
    @Shadow
    protected RecipeType<? extends AbstractCookingRecipe> recipeType;

    protected MixinAbstractFurnaceBlockEntity(BlockEntityType<?> p_155076_, BlockPos p_155077_, BlockState p_155078_) {
        super(p_155076_, p_155077_, p_155078_);
    }

    @Nullable
    protected RecipeHolder<AbstractCookingRecipe> getRecipe() {
        ItemStack input = this.getItem(0);
        if (input.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)this.failedMatch, (ItemStack)input)) {
            return null;
        }
        if (this.curRecipe != null && ((AbstractCookingRecipe)this.curRecipe.value()).matches(new SingleRecipeInput(input), this.level)) {
            return this.curRecipe;
        }
        RecipeHolder rec = this.level.getRecipeManager().getRecipeFor(this.recipeType, (RecipeInput)new SingleRecipeInput(input), this.level).orElse(null);
        this.failedMatch = rec == null ? input.copy() : ItemStack.EMPTY;
        this.curRecipe = rec;
        return this.curRecipe;
    }

    @Inject(at={@At(value="HEAD")}, method={"getTotalCookTime"}, cancellable=true)
    private static void fastfurnace_useFFRecipeCache(Level pLevel, AbstractFurnaceBlockEntity pBlockEntity, CallbackInfoReturnable<Integer> cir) {
        RecipeHolder<AbstractCookingRecipe> rec = ((MixinAbstractFurnaceBlockEntity)pBlockEntity).getRecipe();
        cir.setReturnValue((Object)(rec == null ? 200 : ((AbstractCookingRecipe)rec.value()).getCookingTime()));
    }

    @Redirect(method={"serverTick(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/AbstractFurnaceBlockEntity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/crafting/RecipeManager$CachedCheck;getRecipeFor(Lnet/minecraft/world/item/crafting/RecipeInput;Lnet/minecraft/world/level/Level;)Ljava/util/Optional;"), require=1)
    private static Optional<RecipeHolder<?>> getRecipe(RecipeManager.CachedCheck<?, ?> c, RecipeInput inv, Level level, Level levelAgain, BlockPos pos, BlockState state, AbstractFurnaceBlockEntity blockEntity) {
        return Optional.ofNullable(((MixinAbstractFurnaceBlockEntity)blockEntity).getRecipe());
    }
}

