/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.inventory.container;

import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.inventory.container.ContainerExtended;
import codechicken.lib.inventory.container.SlotHandleClicks;
import codechicken.lib.util.ItemUtils;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.ItemStack;

public class SlotDummy
extends SlotHandleClicks {
    public final int stackLimit;

    public SlotDummy(Container inv, int slot, int x, int y) {
        this(inv, slot, x, y, 64);
    }

    public SlotDummy(Container inv, int slot, int x, int y, int limit) {
        super(inv, slot, x, y);
        this.stackLimit = limit;
    }

    @Override
    public void slotClick(ContainerExtended container, Player player, int button, ClickType clickType) {
        ItemStack held = player.getInventory().player.containerMenu.getCarried();
        boolean shift = clickType == ClickType.QUICK_MOVE;
        this.slotClick(held, button, shift);
    }

    public void slotClick(ItemStack held, int button, boolean shift) {
        ItemStack tstack = this.getItem();
        if (!(held.isEmpty() || !tstack.isEmpty() && InventoryUtils.canStack(held, tstack))) {
            int quantity = Math.min(held.getCount(), this.stackLimit);
            if (shift) {
                quantity = Math.min(this.stackLimit, held.getMaxStackSize() * 16);
            }
            if (button == 1) {
                quantity = 1;
            }
            this.set(ItemUtils.copyStack(held, quantity));
        } else if (!tstack.isEmpty()) {
            int quantity;
            int inc;
            if (!held.isEmpty()) {
                int n = inc = button == 1 ? -held.getCount() : held.getCount();
                if (shift) {
                    inc *= 16;
                }
            } else {
                int n = inc = button == 1 ? -1 : 1;
                if (shift) {
                    inc *= 16;
                }
            }
            if ((quantity = tstack.getCount() + inc) <= 0) {
                this.set(ItemStack.EMPTY);
            } else {
                this.set(ItemUtils.copyStack(tstack, quantity));
            }
        }
    }

    public void set(ItemStack stack) {
        if (!stack.isEmpty() && stack.getCount() > this.stackLimit) {
            stack = ItemUtils.copyStack(stack, this.stackLimit);
        }
        super.set(stack);
    }

    public boolean mayPickup(Player playerIn) {
        return false;
    }
}

